/* mbr.h - Header file: Handling the Master boot record (MBR).
 * Author: Vlastimil Kosar <ikosar@fit.vutbr.cz>
 */

// Info about single partition
typedef struct
{
    uint32_t valid; // is this partition valid
    uint32_t start; // start LBA sector of partition
    uint32_t size;  // size of partition in sectors
    uint32_t fs; // file system type
} t_partition;

// Info about all 4 partitions.
typedef t_partition t_mbr_info[4];

/*
 * Read MBR from SD card, parse it and locate partition which contains image of linux.
 * Params:
 *   info - partition structure
 *   sd_info - SD card parametrs
 * Returns: 1 if everything is OK, 0 if error happend.
 */
uint32_t read_mbr(t_mbr_info *info, t_sd_info *sd_info);
