/* errors.h - Header file: Error codes and error handling.
 * Author: Vlastimil Kosar ikosar@fit.vutbr.cz
 */

// Definition of error codes
#define ERR_SD_INIT 0
#define ERR_SD_READ 1
#define ERR_MBR_NOT_PRESENT 2
#define ERR_MBR_NO_PARTITION 3
#define ERR_FAT_NOT_PRESENT 4
#define ERR_FAT_NOT_FAT16 5
#define ERR_FAT_NOT_FAT32 6
#define ERR_FAT_FILE_NOT_FOUND 7
#define ERR_FAT_FILE_CORUPTED 8
#define ERR_SPI_INIT 9
#define ERR_SPI_OPTIONS 10
#define ERR_SPI_SLAVE_SELECT 11
#define ERR_SPI_TRANSFER 12
#define ERR_SD_CMD0 13
#define ERR_SD_R1 14
#define ERR_SD_CMD8 15
#define ERR_SD_R7 16
#define ERR_SD_CMD55 17
#define ERR_SD_ACMD41 18
#define ERR_SD_CMD16 19
#define ERR_SD_R3 20
#define ERR_SD_CMD17 21
#define ERR_SD_READ_RECEIVE 22
#define ERR_SD_READ_CRC 23
#define ERR_SD_CMD58 24
#define ERR_SD_CMD59 25
#define ERR_SREC_GET_LINE 26
#define ERR_SREC_DECODE_LINE 27
#define SREC_PARSE_ERROR 28
#define SREC_CKSUM_ERROR 29
#define ERR_MEM_TEST 30
#define ERR_FAT16_UNSUPPORTED 31
#define ERR_FAT32_UNSUPPORTED 32
#define ERR_FS_UNSUPPORTED 33

/*
 * Set error indicator.
 * Params:
 *   id - id of error.
 */
void error(uint8_t id);

/*
 * Handle error;
 */
void handle_error();
