/* errors.c - Source file: Error codes and error handling.
 * Author: Vlastimil Kosar ikosar@fit.vutbr.cz
 */

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "parameters.h"
#include "errors.h"

// Error vector
uint8_t err_vect[16] = {255, 255, 255, 255, 255, 255, 255, 255,255, 255, 255, 255, 255, 255, 255, 255};
uint8_t err_index = 0;

/*
 * Set error indicator vector.
 * Params:
 *   id - id of error.
 */
void error(uint8_t id)
{
	err_vect[err_index++] = id;
}

/*
 * Handle error.
 * In debug mode print out
 */
void handle_error()
{
#ifdef DEBUG
	uint8_t i;

	xil_printf("Error log:\r\n");
	for (i = 0; i < err_index; i++)
	{
		switch (err_vect[i])
		{
			case ERR_SD_INIT:
			{
				xil_printf("SD card initialization failed.\r\n");
				break;
			}
			case ERR_SD_READ:
			{
				xil_printf("SD card read failed.\r\n");
				break;
			}
			case ERR_MBR_NOT_PRESENT:
			{
				xil_printf("Master boot record is not present.\r\n");
				break;
			}
			case ERR_MBR_NO_PARTITION:
			{
				xil_printf("No valid partition in Master boot record.\r\n");
				break;
			}
			case ERR_FAT_NOT_PRESENT:
			{
				xil_printf("Supported FAT is not present on selected partition.\r\n");
				break;
			}
			case ERR_FAT_NOT_FAT16:
			{
				xil_printf("FAT type is not FAT16.\r\n");
				break;
			}
			case ERR_FAT_NOT_FAT32:
			{
				xil_printf("Fat type is not FAT32.\r\n");
				break;
			}
			case ERR_FAT_FILE_NOT_FOUND:
			{
				xil_printf("File not found in root directory.\r\n");
				break;
			}
			case ERR_FAT_FILE_CORUPTED:
			{
				xil_printf("File FAT structure is corupted.\r\n");
				break;
			}
			case ERR_SPI_INIT:
			{
				xil_printf("SPI initialization failed.\r\n");
				break;
			}
			case ERR_SPI_OPTIONS:
			{
				xil_printf("Setting SPI options failed.\r\n");
				break;
			}
			case ERR_SPI_SLAVE_SELECT:
			{
				xil_printf("SPI slave select failed.\r\n");
				break;
			}
			case ERR_SPI_TRANSFER:
			{
				xil_printf("SPI data transfer failed.\r\n");
				break;
			}
			case ERR_SD_CMD0:
			{
				xil_printf("SD card command CMD0 failed.\r\n");
				break;
			}
			case ERR_SD_R1:
			{
				xil_printf("SD card response R1 failed.\r\n");
				break;
			}
			case ERR_SD_CMD8:
			{
				xil_printf("SD card command CMD8 failed.\r\n");
				break;
			}
			case ERR_SD_R7:
			{
				xil_printf("SD card response R7 failed.\r\n");
				break;
			}
			case ERR_SD_CMD55:
			{
				xil_printf("SD card command CMD55 failed.\r\n");
				break;
			}
			case ERR_SD_ACMD41:
			{
				xil_printf("SD card command ACMD41 failed.\r\n");
				break;
			}
			case ERR_SD_CMD16:
			{
				xil_printf("SD card command CMD16 failed.\r\n");
				break;
			}
			case ERR_SD_R3:
			{
				xil_printf("SD card respose R3 failed.\r\n");
				break;
			}
			case ERR_SD_CMD17:
			{
				xil_printf("SD card command CMD17 failed.\r\n");
				break;
			}
			case ERR_SD_READ_RECEIVE:
			{
				xil_printf("Read of 512B block from SD card failed.\r\n");
				break;
			}
			case ERR_SD_READ_CRC:
			{
				xil_printf("SD card 512B block corupted - CRC16 mismatch.\r\n");
				break;
			}
			case ERR_SD_CMD58:
			{
				xil_printf("SD card command CMD58 failed.\r\n");
				break;
			}
			case ERR_SD_CMD59:
			{
				xil_printf("SD card command CMD59 failed.\r\n");
				break;
			}
			case ERR_SREC_GET_LINE:
			{
				xil_printf("SREC line extraction from image failed.\r\n");
				break;
			}
			case ERR_SREC_DECODE_LINE:
			{
				xil_printf("SREC line decoding failed.\r\n");
				break;
			}
			case SREC_PARSE_ERROR:
			{
				xil_printf("SREC line parsing error.\r\n");
				break;
			}
			case SREC_CKSUM_ERROR:
			{
				xil_printf("SREC line checksum error.\r\n");
				break;
			}
			case ERR_MEM_TEST:
			{
				xil_printf("SREC line checksum error.\r\n");
				break;
			}
            case ERR_FAT16_UNSUPPORTED:
            {
                xil_printf("FAT16 unsupported.\r\n");
                break;
            }
            case ERR_FAT32_UNSUPPORTED:
            {
                xil_printf("FAT32 unsupported.\r\n");
                break;
            }
            case ERR_FS_UNSUPPORTED:
            {
                xil_printf("Unknown filesystem.\r\n");
                break;
            }
		}
	}
#endif

    //exit(-1);
    for(;;)
    {
        ;
    }
}
