/******************************************************************************/
/*                             Start of crcmodel.c                            */
/******************************************************************************/

/**
 * \file pycrc_stdout
 * Functions and types for CRC checks.
 *
 * Generated on Mon Oct 31 16:30:34 2011,
 * by pycrc v0.7.8, http://www.tty1.net/pycrc/
 * using the configuration:
 *    Width        = 7
 *    Poly         = 0x09
 *    XorIn        = 0x00
 *    ReflectIn    = False
 *    XorOut       = 0x00
 *    ReflectOut   = False
 *    Algorithm    = bit-by-bit-fast
 *****************************************************************************/
#include "crcmodel.h"     /* include the header file generated with pycrc */
#include <stdint.h>
#include <stdlib.h>


/**
 * Update the crc value with new data.
 *
 * \param crc      The current crc value.
 * \param data     Pointer to a buffer of \a data_len bytes.
 * \param data_len Number of bytes in the \a data buffer.
 * \return         The updated crc value.
 *****************************************************************************/
crc7_t crc7_update(crc7_t crc, const uint8_t *data, uint32_t data_len)
{
    uint32_t i;
    int32_t bit;
    uint8_t c;

    while (data_len--) {
        c = *data++;
        for (i = 0x80; i > 0; i >>= 1) {
            bit = crc & 0x40;
            if (c & i) {
                bit = !bit;
            }
            crc <<= 1;
            if (bit) {
                crc ^= 0x09;
            }
        }
        crc &= 0x7f;
    }
    return crc & 0x7f;
}

/**
 * \file pycrc_stdout
 * Functions and types for CRC checks.
 *
 * Generated on Mon Oct 31 16:35:13 2011,
 * by pycrc v0.7.8, http://www.tty1.net/pycrc/
 * using the configuration:
 *    Width        = 16
 *    Poly         = 0x1021
 *    XorIn        = 0x0000
 *    ReflectIn    = False
 *    XorOut       = 0x0000
 *    ReflectOut   = False
 *    Algorithm    = bit-by-bit-fast
 *****************************************************************************/

/**
 * Update the crc value with new data.
 *
 * \param crc      The current crc value.
 * \param data     Pointer to a buffer of \a data_len bytes.
 * \param data_len Number of bytes in the \a data buffer.
 * \return         The updated crc value.
 *****************************************************************************/
crc16_t crc16_update(crc16_t crc, const uint8_t *data, uint32_t data_len)
{
    uint32_t i;
    int32_t bit;
    uint8_t c;

    while (data_len--) {
        c = *data++;
        for (i = 0x80; i > 0; i >>= 1) {
            bit = crc & 0x8000;
            if (c & i) {
                bit = !bit;
            }
            crc <<= 1;
            if (bit) {
                crc ^= 0x1021;
            }
        }
        crc &= 0xffff;
    }
    return crc & 0xffff;
}

/******************************************************************************/
/*                             End of crcmodel.c                              */
/******************************************************************************/
