/* compose.h - Header file: Composition functions.
 * Author: Vlastimil Kosar <ikosar@fit.vutbr.cz>
 */

#define LITTLE 0
#define BIG 1

/*
 * Compose 2 consequtive bytes into one 16-bit number. Convert endianness if necessery.
 * Params:
 *   data - pointer to array of bytes.
 *   source_endian - source endian LITTLE/BIG
 *   destination_endian - destination endian LITTLE/BIG
 *  Returns composed number.
 */
uint16_t compose_16(uint8_t *data, uint8_t source_endian, uint8_t destination_endian);

/*
 * Compose 4 consequtive bytes into one 32-bit number. Convert endianness if necessery.
 * Params:
 *   data - pointer to array of bytes.
 *   source_endian - source endian LITTLE/BIG
 *   destination_endian - destination endian LITTLE/BIG
 *  Returns composed number.
 */
uint32_t compose_32(uint8_t *data, uint8_t source_endian, uint8_t destination_endian);
