////////////////////////////////////////////////////////////////////////////////////////////////////
//\file  D:\BioMarker\Software\Iterative\include\Windowing.h
//
//\brief Declares the windowing class. 
//			
//			2D window function initialization based on:
//			http://fli10.wordpress.com/2011/03/30/forming-a-2d-window-from-a-1d-function/
//			
//			Window functions:
//			http://en.wikipedia.org/wiki/Window_function
//	
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef Windowing_H_included
#define Windowing_H_included

#include <MDSTk/Image/mdsImage.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
//\class CWindow
//
//\brief Form for viewing the c. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CWindow
{
public:
   //! Constructor
   CWindow( mds::tSize width, mds::tSize height );

   //! Apply window on pixel
   template< typename tPixel > 
   tPixel apply( int x, int y, const tPixel & pixel ) const
   {
      if( x >= 0 && x < m_w && y >= 0 && y < m_h )
         return pixel * m_window->get( x, y );

      return m_outside * pixel;
   }

protected:
   //! Initialize window by product way
   void initByProduct( float * dataX, float * dataY );

   //! Reinitialize window
   void create( mds::tSize width, mds::tSize height );

protected:
   //! Window data
   mds::img::CFImagePtr m_window;

   //! Window size
   int m_w, m_h;

   //! Outside window value
   float m_outside;

}; // class CWindowing

class CTukeyWindow : public CWindow
{
public:
   //! Constructor
   CTukeyWindow( mds::tSize size, mds::tSize lobeSize );

   //! Non square window constructor
   CTukeyWindow( mds::tSize width, mds::tSize height, mds::tSize lobeX, mds::tSize lobeY ) : CWindow( width, height ) { init( width, height, lobeX, lobeY ); }

   //! Reinitialize window
   void init( mds::tSize width, mds::tSize height, mds::tSize lobeX, mds::tSize lobeY );

}; // class CTukeyWindow

// Windowing_H_included
#endif

