////////////////////////////////////////////////////////////////////////////////////////////////////
//\file  D:\BioMarker\Software\Iterative\include\RichardsonLucy.h
//
//\brief Declares the richardson lucy filter class. 
// 
// Based on:
// Reference Type: Book Chapter
// Editor: Rietdorf, Jens
// Author: Sibarita, Jean-Baptiste
// Primary Title: Deconvolution Microscopy
// Book Title: Microscopy Techniques
// Book Series Title: Advances in Biochemical Engineering/Biotechnology
// Copyright: 2005
// Publisher: Springer Berlin / Heidelberg
// Isbn: 
// Start Page: 1288
// End Page: 1291
// Volume: 95
// Url: http://dx.doi.org/10.1007/b102215
// Doi: 10.1007/b102215
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RichardsonLucy_H_included
#define RichardsonLucy_H_included

#include "ComplexFilter.h"

class CRichardsonLucy : public CComplexFilter
{
public:
   //! Constructor
   CRichardsonLucy();

   //! Initializing constructor
   CRichardsonLucy( const tIImage & input, const tIImage & psf );

    //! Initialize - set input, set PSF 
   virtual bool init( const tIImage & input, const tIImage & psf );

   //! Initialize - get frequency domain data
   virtual bool initFD( const tImage & input, const tImage & psf );

   //! Do one iteration
   virtual void step();

   //! Filter 
   virtual int filter( mds::tSize max_steps );

   //! Get filter output
   virtual void getOutput( tImage & image );

   //! Get filter output - frequency domain
   virtual void getOutputFD( tImage & image );

protected:
   

protected:
public:
   //! Blurred image - spatial and frequency domain
   tImagePtr m_B, m_Bf;

   //! Ratios image - spatial and frequency domain
   tImagePtr m_R, m_Rf;

   //! Corrections image - spatial and frequency domain
   tImagePtr m_C, m_Cf;

   //! Current estimation image
   tImagePtr m_E, m_Ef;

   //! Complex conjugate of the psf - only frequency domain
   tImagePtr m_PSFCf;

}; // class CRichardsonLucy


// RichardsonLucy_H_included
#endif

