////////////////////////////////////////////////////////////////////////////////////////////////////
//\file  D:\BioMarker\Software\Iterative\include\Region.h
//
//\brief Declares the rectangle class. 
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef Region_H_included
#define Region_H_included

////////////////////////////////////////////////////////////////////////////////////////////////////
//\class CRegion2D
//
//\brief Region in 2d. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CRegion2D
{
public:
   //! Constructor
   CRegion2D() : m_x( 0 ), m_y( 0 ), m_w( 0 ), m_h( 0 ) {}

   //! Copy constructor
   CRegion2D( const CRegion2D & region ) 
      : m_x( region.m_x )
      , m_y( region.m_y )
      , m_w( region.m_w )
      , m_h( region.m_h ) {}

   //! Initializing constructor
   CRegion2D( int x, int y, int w, int h ) : m_x( x ), m_y( y ), m_w( w ), m_h( h ) {}

   //! Assignment operator
   CRegion2D & operator = ( const CRegion2D & region );

   //! Is region valid (sizes > 0)?
   bool valid( ) { return m_w > 0 && m_h > 0; }

   //! Compute common part of two regions
   static bool getCommon( const CRegion2D & r1, const CRegion2D & r2, CRegion2D & result );

   //! Is first region included in the second one?
   static bool isIn( const CRegion2D & r1, const CRegion2D & r2 );

   //! Get and set x
   int & x() { return m_x; }

   //! Only get x
   int getX() { return m_x; }

   //! Get and set y
   int & y() { return m_y; }

   //! Only get y
   int getY() { return m_y; }

   //! Get and set h
   int & h() { return m_h; }

   //! Only get h
   int getH() { return m_h; }

   //! Get and set w
   int & w() { return m_w; }

   //! Only get y
   int getW() { return m_w; }

   //! Set position
   void setPosition( int x, int y ) { m_x = x; m_y = y; }

   //! Get position
   void getPosition( int & x, int & y ) { x = m_x; y = m_y; }

   //! Set rectangle size
   void setSize( int w, int h ) { m_w = w; m_h = h; }

   //! Get rectangle size
   void getSize( int & w, int & h ) { w = m_w; h = m_h; }

protected:
   //! Left top corner coordinates
   int m_x, m_y;

   //! Region size
   int m_w, m_h;

};

// Region_H_included
#endif