////////////////////////////////////////////////////////////////////////////////////////////////////
//\file  D:\BioMarker\Software\Iterative\include\MLE.h
//
//\brief Declares the mle class. 
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef MLE_H_included
#define MLE_H_included

#include "ComplexFilter.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
//\class CMLE
//
//\brief Maximum likelihood filter. 
//			Based on: http://mipav.cit.nih.gov/documentation/HTML%20Algorithms/MicroscopyBlindDeconvolution.html
////////////////////////////////////////////////////////////////////////////////////////////////////

class CMLE : public CComplexFilter
{
public:
   //! Constructor
   CMLE();

   //! Initialize - set input, set PSF 
   virtual bool init( const tIImage & input, const tIImage & psf );

   //! Initialize - use frequency domain data
   virtual bool initFD( const tImage & input, const tImage & psf );

   //! Do one iteration
   virtual void step();

   //! Filter 
   virtual int filter( mds::tSize max_steps );

   //! Get filter output
   virtual void getOutput( tImage & image );

   //! Get filter output - frequency domain
   virtual void getOutputFD( tImage & image );

protected:
   //! Compute shared part
   void computeShared();

protected:
   //! Working copies of input data
   tImagePtr m_wG, m_wGfd;

   //! Working copies of PSF function
   tImagePtr m_wP, m_wPfd;

   //! Transformed psf copy
   tImagePtr m_wPT, m_wPTfd;

   //! Transformed working input copy
   tImagePtr m_wGT, m_wGTfd;

   //! Shared part buffer
   tImagePtr m_shared;

}; // class CMLE


// MLE_H_included
#endif

