////////////////////////////////////////////////////////////////////////////////////////////////////
//!\file include\DenoisedMLE.h
//!
//!\author  Vit Stancl
//!\date 22.3.2011
//!\brief   Declares the denoised mle class. 
//!         Based on:
//!         Author: Green, P. J. 
//!         Title: Bayesian reconstructions from emission tomography data using a modified EM algorithm. 
//!         Publicated: IEEE Transactions on Medical Imaging 9, 1 (1990), 8493.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef DenoisedMLE_H_included
#define DenoisedMLE_H_included

#include "ComplexFilter.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
//!\brief   Denoised maximum likelihood filter. 
////////////////////////////////////////////////////////////////////////////////////////////////////
class CDenoisedMLE : public CComplexFilter
{
   public:
   //! Constructor
   CDenoisedMLE();

   //! Initialize - set input, set PSF 
   virtual bool init( const tIImage & input, const tIImage & psf );

   //! Initialize - use frequency domain data
   virtual bool initFD( const tImage & input, const tImage & psf );

   //! Do one iteration
   virtual void step();

   //! Filter 
   virtual int filter( mds::tSize max_steps );

   //! Get filter output
   virtual void getOutput( tImage & image );

   //! Get filter output - frequency domain
   virtual void getOutputFD( tImage & image );

protected:
   //! Compute shared part
   void computeShared();

   //! Denoise
   void denoise( tImage & image );

protected:
   //! Working copies of input data
   tImagePtr m_wG, m_wGfd;

   //! Working copies of PSF function
   tImagePtr m_wP, m_wPfd;

   //! Transformed psf copy
   tImagePtr m_wPT, m_wPTfd;

   //! Transformed working input copy
   tImagePtr m_wGT, m_wGTfd;

   //! Shared part buffer
   tImagePtr m_shared;

}; // class CDenoisedMLE

// DenoisedMLE_H_included
#endif
