/* 
 * File:   point3d.cpp
 * Author: Bronislav Přibyl
 * 
 * Created on 27. duben 2010, 18:08
 */

#include "point3d.h"

Point3D::Point3D ()
{
}

Point3D::Point3D (double x, double y, double z)
{
	this->x = x;
	this->y = y;
	this->z = z;
}

Point3D::Point3D (const Point3D& orig)
{
	this->x = orig.x;
	this->y = orig.y;
	this->z = orig.z;
}

Point3D::~Point3D ()
{
}

void Point3D::print()
{
	std::cout << "x: " << this->x << ";";
	std::cout << "\ty: " << this->y << ";";
	std::cout << "\tz: " << this->z << ";";
}

double Point3D::distanceTo (Point3D point)
{
	return sqrt(SQR(this->x - point.x) + SQR(this->y - point.y) + SQR(this->z - point.z));
}

