/* 
 * File:   object2detect.cpp
 * Author: Bronislav Přibyl
 * 
 * Created on 28. prosinec 2009, 15:58
 */

#include "object2detect.h"


/**
 * Default constructor.
 */
Object2Detect::Object2Detect (std::string typeName, double width, double height, double elevation)
{
	this->setTypeName(typeName);
	this->setWidth(width);
	this->setHeight(height);
	this->setElevation(elevation);
}

/**
 * Copy constructor.
 */
Object2Detect::Object2Detect (const Object2Detect& orig)
{
	this->typeName = orig.typeName;
	this->width = orig.width;
	this->height = orig.height;
	this->elevation = orig.elevation;
}


/**
 * Destructor.
 */
Object2Detect::~Object2Detect ()
{
}

std::string Object2Detect::getTypeName()
{
	return this->typeName;
}

void Object2Detect::setTypeName (std::string typeName)
{
	this->typeName = typeName;
}

double Object2Detect::getWidth ()
{
	return this->width;
}

void Object2Detect::setWidth (double width)
{
	this->width = width;
}

double Object2Detect::getHeight ()
{
	return this->height;
}

void Object2Detect::setHeight (double height)
{
	this->height = height;
}

double Object2Detect::getElevation ()
{
	return this->elevation;
}

void Object2Detect::setElevation (double elevation)
{
	this->elevation = elevation;
}

void Object2Detect::print ()
{
	std::cout << "type name: " << this->typeName << ";";
	std::cout << "\twidth: " << this->width << ";";
	std::cout << "\theight: " << this->height << ";";
	std::cout << "\televation: " << this->elevation << ";";
}
