/* 
 * File:   detectedobject.h
 * Author: Bronislav Přibyl
 *
 * Created on 27. duben 2010, 12:08
 */

#ifndef _DETECTEDOBJECT_H
#define	_DETECTEDOBJECT_H

#include "object2detect.h"
#include "point3d.h"


class DetectedObject {

public:
	DetectedObject (Object2Detect *objectType, std::string name, Point3D coords);
	DetectedObject (const DetectedObject& orig);
	virtual ~DetectedObject ();

	std::string getTypeName ();
	double getWidth ();
	double getHeight ();
	double getElevation ();
	std::string getName ();
	Point3D getCoords ();

	void print ();
	double distanceTo (DetectedObject object);

private:
	std::string typeName; // object type name
	double width; // expected horizontal size
	double height; // expected vertical size
	double elevation; // expected height above ground (activity plane)
	std::string name;
	Point3D coords;

	void setTypeName (std::string typeName);
	void setWidth (double width);
	void setHeight (double height);
	void setElevation (double elevation);
	void setName (std::string name);
	void setCoords (Point3D coords);
};

#endif	/* _DETECTEDOBJECT_H */

