/* 
 * File:   detectedobject.cpp
 * Author: Bronislav Přibyl
 * 
 * Created on 27. duben 2010, 12:08
 */

#include "detectedobject.h"

/**
 * Default constructor.
 */
DetectedObject::DetectedObject (Object2Detect *objectType, std::string name, Point3D coords)
{
	this->setTypeName(objectType->getTypeName());
	this->setWidth(objectType->getWidth());
	this->setHeight(objectType->getHeight());
	this->setElevation(objectType->getElevation());
	this->setName(name);
	this->setCoords(coords);
}

/**
 * Copy constructor.
 */
DetectedObject::DetectedObject (const DetectedObject& orig)
{
	this->typeName = orig.typeName;
	this->width = orig.width;
	this->height = orig.height;
	this->elevation = orig.elevation;
	this->name = orig.name;
	this->coords = orig.coords;
}

DetectedObject::~DetectedObject ()
{
}

std::string DetectedObject::getTypeName()
{
	return this->typeName;
}

void DetectedObject::setTypeName (std::string typeName)
{
	this->typeName = typeName;
}

double DetectedObject::getWidth ()
{
	return this->width;
}

void DetectedObject::setWidth (double width)
{
	this->width = width;
}

double DetectedObject::getHeight ()
{
	return this->height;
}

void DetectedObject::setHeight (double height)
{
	this->height = height;
}

double DetectedObject::getElevation ()
{
	return this->elevation;
}

void DetectedObject::setElevation (double elevation)
{
	this->elevation = elevation;
}

std::string DetectedObject::getName()
{
	return this->name;
}

void DetectedObject::setName(std::string name)
{
	this->name = name;
}

Point3D DetectedObject::getCoords()
{
	return this->coords;
}

void DetectedObject::setCoords(Point3D coords)
{
	this->coords = coords;
}

void DetectedObject::print()
{
	std::cout << "type name: " << this->typeName << ";";
	std::cout << "\twidth: " << this->width << ";";
	std::cout << "\theight: " << this->height << ";";
	std::cout << "\televation: " << this->elevation << ";";
	std::cout << std::endl;
	std::cout << "name: " << this->name << ";";
	std::cout << "\t";
	this->getCoords().print();
}

double DetectedObject::distanceTo(DetectedObject object)
{
	return this->coords.distanceTo(object.getCoords());
}
