#!/bin/sh

# parameters: gnuplot.sh <err-eigenval-values> <err-eigenval-plot> <err-3D-points-values> <err-3D-points-plot> <3D-points-count>
# parameters example: gnuplot.sh error-eigenval.txt error-eigenval.png error-3Dpoints-to-plane-dist.txt error-3Dpoints-to-plane-dist.png 5

MINPARAMS=5
if [ $# -lt "$MINPARAMS" ]
then
  echo "Too few parameters. Syntax: gnuplot.sh <err-eigenval-values> <err-eigenval-plot> <err-3D-points-values> <err-3D-points-plot> <3D-points-count>"
  exit 1
fi

POINTS=$5
if [ $POINTS -lt 1 ]
then
  echo "5th parameter must be > 0."
  exit 1
fi




############################### PLOT EIGENVALUES ###############################

# set parameters
params=""


param=" set terminal png size 1670,890;"
params=$params$param

param=" set output '$2';"
params=$params$param

#param=" set logscale x
#"
#params=$params$param

param=" set logscale y
"
params=$params$param

param=" plot '$1'"
#param=" plot 'error-eigenval.txt'"
params=$params$param

param=" using '%lf;%lf'"
params=$params$param

param=" smooth unique"
params=$params$param
	
param=" linewidth 2.0"
params=$params$param

param=" title 'error'"
params=$params$param

# execute gnuplot
echo "$params" | gnuplot

############################# PLOT DISTANCE OF 3D POINTS #######################

# set parameters
params=""


param=" set terminal png size 1670,890;"
params=$params$param

param=" set output '$4';"
params=$params$param

#param=" set logscale x
#"
#params=$params$param

#param=" set logscale y
#"
#params=$params$param

param=" plot 0 linecolor -1"
params=$params$param


pointNr=0
# for each 3D point construct gnuplot commands
while [  $pointNr -lt $POINTS ]; do
	pointNr=`expr $pointNr + 1`
	
	param=", '$3'"
	params=$params$param
	
	# construct format string for the point --------------------------------------
	format=" using '%lf"
	
	# skipped columns before 
	tmp=1
	while [ $tmp -lt $pointNr ]; do
		format=$format";%*lf"
		tmp=`expr $tmp + 1`
	done
	
	# chosen column
	format=$format";%lf"
	tmp=`expr $tmp + 1`
	
	# skipped columns after
	while [ $tmp -le $POINTS ]; do
		format=$format";%*lf"
		tmp=`expr $tmp + 1`
	done
	
	# terminator
	format=$format"'"
	# ----------------------------------------------------------------------------
	
	params=$params$format
	
	param=" smooth unique"
	params=$params$param
	
	param=" linewidth 2.0"
	params=$params$param
	
	param=" title 'distance $pointNr'"
	params=$params$param
done


#param=", 'error-3Dpoints-to-plane-dist.txt'"
#params=$params$param

#param=" using '%lf;%*lf;%*lf;%*lf;%*lf;%lf'"
#params=$params$param

#param=" title 'distance 5'"
#params=$params$param

# execute gnuplot
echo "$params" | gnuplot

