/*
 * Decompiled with CFR 0.152.
 */
package annotator.tasks;

import annotator.Picture;
import annotator.Project;
import annotator.tasks.ExportDotTask;
import annotator.tasks.ExportSVGTask;
import annotator.tasks.ImportSVGTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task {
    protected static Map<String, List<Task>> tasks = new HashMap<String, List<Task>>();

    public abstract String getName();

    public abstract void launch(Project var1, Picture var2);

    public abstract String getDescription();

    public abstract String getCategory();

    public abstract Icon getIcon();

    public static void init() {
        Task.addTask(new ExportDotTask());
        Task.addTask(new ExportSVGTask());
        Task.addTask(new ImportSVGTask());
    }

    public static Map<String, List<Task>> getTasksByCategory() {
        return tasks;
    }

    private static void addTask(Task task) {
        String category = task.getCategory();
        if (!tasks.containsKey(category)) {
            tasks.put(category, new ArrayList());
        }
        tasks.get(task.getCategory()).add(task);
    }
}

