/*
 * Decompiled with CFR 0.152.
 */
package annotator.tasks;

import annotator.Picture;
import annotator.Project;
import annotator.annotations.Annotable;
import annotator.annotations.Annotation;
import annotator.annotations.AnnotationProxy;
import annotator.graph.AdjacentRelation;
import annotator.graph.Edge;
import annotator.graph.ImageNextToRelation;
import annotator.graph.InSegmentRelation;
import annotator.graph.Line;
import annotator.graph.Point;
import annotator.graph.Relation;
import annotator.graph.SceneNextToRelation;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import annotator.tasks.Task;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportSVGTask
extends Task {
    public String getName() {
        return "Import SVG...";
    }

    public void launch(Project project, Picture picture) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        int result = fc.showOpenDialog(null);
        if (result != 0) {
            return;
        }
        String filePath = fc.getSelectedFile().getAbsolutePath();
        DocumentBuilder db = null;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            JOptionPane.showMessageDialog(null, "Parser initialization failed");
            return;
        }
        Document document = null;
        try {
            document = db.parse(new File(filePath));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not load file");
            return;
        }
        Element segmentsGroup = this.findGroupElement(document, "segments");
        NodeList segmentNodeList = segmentsGroup.getElementsByTagName("path");
        for (int i = 0; i < segmentNodeList.getLength(); ++i) {
            Element segmentElement = (Element)segmentNodeList.item(i);
            Segment segment = new Segment(picture);
            this.importAnnotations(segmentElement, segment);
            segment.initCache();
            picture.segments().add(segment);
        }
        Element edgesGroup = this.findGroupElement(document, "edges");
        NodeList edgeNodeList = edgesGroup.getElementsByTagName("path");
        for (int i = 0; i < edgeNodeList.getLength(); ++i) {
            Element edgeElement = (Element)edgeNodeList.item(i);
            String data = edgeElement.getAttribute("d");
            data = this.removeCurveControlPoints(data);
            Pattern pattern = Pattern.compile("^(.*?)([-0-9.]*),([-0-9.]*)(.*)$");
            Matcher matcher = pattern.matcher(data);
            boolean relativeInput = false;
            if (data.trim().startsWith("m")) {
                relativeInput = true;
            }
            Edge edge = new Edge(picture);
            this.importAnnotations(edgeElement, edge);
            Point lastPoint = null;
            Point firstPoint = null;
            while (matcher.matches()) {
                Point currentPoint;
                if (lastPoint == null || !relativeInput) {
                    currentPoint = new Point(Math.round(Float.parseFloat(matcher.group(2))), Math.round(Float.parseFloat(matcher.group(3))));
                } else {
                    int x = Math.round(Float.parseFloat(matcher.group(2)));
                    int y = Math.round(Float.parseFloat(matcher.group(3)));
                    currentPoint = new Point(lastPoint.x + Math.round(Float.parseFloat(matcher.group(2))), lastPoint.y + Math.round(Float.parseFloat(matcher.group(3))));
                }
                if (lastPoint != null) {
                    Line line = new Line(lastPoint, currentPoint);
                    line.assignToEdge(edge);
                    if (firstPoint == null) {
                        firstPoint = lastPoint;
                    }
                }
                lastPoint = currentPoint;
                data = matcher.group(4);
                matcher = pattern.matcher(data);
            }
            if (data.contains("z") && lastPoint != null) {
                Line line = new Line(lastPoint, firstPoint);
                line.assignToEdge(edge);
            }
            picture.singleEdges().add(edge);
            edge.initCache();
        }
        Element objectsGroup = this.findGroupElement(document, "objects");
        NodeList objectNodeList = objectsGroup.getElementsByTagName("rect");
        for (int i = 0; i < objectNodeList.getLength(); ++i) {
            Element objectElement = (Element)objectNodeList.item(i);
            int xRaw = Math.round(Float.parseFloat(objectElement.getAttribute("x")));
            int yRaw = Math.round(Float.parseFloat(objectElement.getAttribute("y")));
            int width = Math.round(Float.parseFloat(objectElement.getAttribute("width")));
            int height = Math.round(Float.parseFloat(objectElement.getAttribute("height")));
            int x = xRaw + width / 2;
            int y = yRaw + height / 2;
            SceneObject object = new SceneObject(picture, x, y);
            this.importAnnotations(objectElement, object);
            picture.objects().add(object);
            object.initCache();
        }
        Element relationsGroup = (Element)document.getElementsByTagName("relations").item(0);
        NodeList relationsNodeList = relationsGroup.getElementsByTagName("relation");
        for (int i = 0; i < relationsNodeList.getLength(); ++i) {
            Element relationElement = (Element)relationsNodeList.item(i);
            String type = relationElement.getAttribute("type");
            String sourceName = relationElement.getAttribute("from");
            String destinationName = relationElement.getAttribute("to");
            Annotable source = this.getAnnotableByName(picture, sourceName);
            Annotable destination = this.getAnnotableByName(picture, destinationName);
            if (source == null || destination == null) continue;
            Relation relation = null;
            if (type.equalsIgnoreCase("boundary")) {
                Segment segment = (Segment)source;
                Edge edge = (Edge)destination;
                edge.assignToSegment(segment);
            } else if (type.equalsIgnoreCase("in_segment")) {
                relation = new InSegmentRelation(picture, source, destination);
            } else if (type.equalsIgnoreCase("next_to_image")) {
                relation = new ImageNextToRelation(picture, source, destination);
            } else if (type.equalsIgnoreCase("next_to_scene")) {
                relation = new SceneNextToRelation(picture, source, destination);
            } else if (type.equalsIgnoreCase("adjacent")) {
                relation = new AdjacentRelation(picture, source, destination);
            }
            if (relation == null) continue;
            this.importAnnotations(relationElement, relation);
            picture.relations().add(relation);
        }
    }

    private Element findGroupElement(Document document, String id) {
        NodeList elements = document.getElementsByTagName("g");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            if (!(element.getAttribute("id") == null ? id == null : element.getAttribute("id").equals(id))) continue;
            return element;
        }
        return null;
    }

    private String removeCurveControlPoints(String data) {
        String oldret = data;
        String ret = data;
        do {
            oldret = ret;
        } while (!(ret = ret.replaceAll("(c\\s*[-0-9.]*,[-0-9.]*\\s+[-0-9.]*,[-0-9.]*\\s+[-0-9.]*,[-0-9.]*\\s+)([^lc\\s])", "$1 c $2")).equals(oldret));
        ret = ret.replaceAll("c\\s*([-0-9.]*),([-0-9.]*)\\s+([-0-9.]*),([-0-9.]*)", "");
        return ret;
    }

    private Annotable getAnnotableByName(Picture picture, String sourceName) {
        for (Edge edge : picture.allEdges()) {
            if (!edge.getName(false).equalsIgnoreCase(sourceName)) continue;
            return edge;
        }
        for (SceneObject object : picture.objects()) {
            if (!object.getName(false).equalsIgnoreCase(sourceName)) continue;
            return object;
        }
        for (Segment segment : picture.segments()) {
            if (!segment.getName(false).equalsIgnoreCase(sourceName)) continue;
            return segment;
        }
        return null;
    }

    private void importAnnotations(Element element, Annotable annotable) {
        AnnotationProxy annotationProxy = annotable.getAnnotationProxy();
        Map<String, Annotation> annotations = annotationProxy.getAnnotations();
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            Node attribute = element.getAttributes().item(i);
            String nodeName = attribute.getNodeName();
            String nodeValue = attribute.getNodeValue();
            if (!annotations.containsKey(nodeName)) continue;
            annotations.get(nodeName).importValue(nodeValue);
        }
    }

    public String getDescription() {
        return "Imports scene graph from the SVG file into the current picture";
    }

    public Icon getIcon() {
        return null;
    }

    public String getCategory() {
        return "Tasks";
    }
}

