/*
 * Decompiled with CFR 0.152.
 */
package annotator.tasks;

import annotator.Picture;
import annotator.Project;
import annotator.annotations.Annotable;
import annotator.annotations.Annotation;
import annotator.graph.Edge;
import annotator.graph.Line;
import annotator.graph.Point;
import annotator.graph.Relation;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import annotator.tasks.Task;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportSVGTask
extends Task {
    @Override
    public String getName() {
        return "Export to SVG...";
    }

    @Override
    public void launch(Project project, Picture picture) {
        Element relationElement;
        Point startPoint;
        StringBuffer sb;
        Element path;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File(picture.getFilename() + ".svg"));
        int result = fc.showSaveDialog(null);
        if (result != 0) {
            return;
        }
        String filePath = fc.getSelectedFile().getAbsolutePath();
        String NS_SODIPODI = "http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd";
        String NS_INKSCAPE = "http://www.inkscape.org/namespaces/inkscape";
        String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
        DocumentBuilder db = null;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(ExportSVGTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        Document doc = db.newDocument();
        Element root = doc.createElement("svg");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sodipodi", "http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:inkscape", "http://www.inkscape.org/namespaces/inkscape");
        doc.appendChild(root);
        Element segmentsGroup = doc.createElement("g");
        segmentsGroup.setAttribute("id", "segments");
        segmentsGroup.setAttributeNS("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi:insensitive", "true");
        segmentsGroup.setAttribute("style", "display:inline");
        segmentsGroup.setAttributeNS("http://www.inkscape.org/namespaces/inkscape", "inkscape:groupmode", "layer");
        segmentsGroup.setAttributeNS("http://www.inkscape.org/namespaces/inkscape", "inkscape:label", "segments");
        root.appendChild(segmentsGroup);
        CopyOnWriteArraySet<Edge> edges = new CopyOnWriteArraySet<Edge>();
        for (Segment segment : picture.segments()) {
            edges.addAll(segment.edges());
            Vector<Line> lines = this.sortLines(segment.getLines());
            path = doc.createElement("path");
            segmentsGroup.appendChild(path);
            path.setAttribute("id", segment.getName(true));
            path.setAttributeNS("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi:nodetypes", this.repeatChar('c', lines.size() + 1));
            path.setAttribute("style", "fill:none;stroke:#0000ff;stroke-opacity:1");
            sb = new StringBuffer("");
            startPoint = lines.firstElement().getPointA();
            sb.append("M ");
            sb.append(startPoint.x);
            sb.append(",");
            sb.append(startPoint.y);
            sb.append(" L");
            for (Line line : lines) {
                sb.append(" ");
                sb.append(line.getPointB().x);
                sb.append(",");
                sb.append(line.getPointB().y);
            }
            path.setAttribute("d", sb.toString());
            path.setAttribute("vertex", "SEGMENT");
            this.exportAnnotations(path, segment);
        }
        for (Edge edge : picture.singleEdges()) {
            if (edges.contains(edge)) continue;
            edges.add(edge);
        }
        Element edgesGroup = doc.createElement("g");
        edgesGroup.setAttribute("style", "display:inline");
        edgesGroup.setAttributeNS("http://www.inkscape.org/namespaces/inkscape", "inkscape:groupmode", "layer");
        edgesGroup.setAttributeNS("http://www.inkscape.org/namespaces/inkscape", "inkscape:label", "edges");
        edgesGroup.setAttribute("id", "edges");
        root.appendChild(edgesGroup);
        for (Edge edge : edges) {
            sb = new StringBuffer("");
            path = doc.createElement("path");
            edgesGroup.appendChild(path);
            path.setAttribute("id", edge.getName(true));
            startPoint = edge.getLines().firstElement().getPointA();
            sb.append("M ");
            sb.append(startPoint.x);
            sb.append(",");
            sb.append(startPoint.y);
            sb.append(" L");
            for (Line line : edge.getLines()) {
                sb.append(" ");
                sb.append(line.getPointB().x);
                sb.append(",");
                sb.append(line.getPointB().y);
            }
            path.setAttribute("d", sb.toString());
            path.setAttribute("vertex", "EDGE");
            path.setAttributeNS("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi:nodetypes", this.repeatChar('c', edge.getLines().size() + 1));
            path.setAttribute("style", "fill:none;stroke:#ff0000;stroke-opacity:1");
            this.exportAnnotations(path, edge);
        }
        Element objectsGroup = doc.createElement("g");
        objectsGroup.setAttribute("id", "objects");
        objectsGroup.setAttributeNS("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi:insensitive", "true");
        objectsGroup.setAttribute("style", "display:inline");
        objectsGroup.setAttributeNS("http://www.inkscape.org/namespaces/inkscape", "inkscape:groupmode", "layer");
        objectsGroup.setAttributeNS("http://www.inkscape.org/namespaces/inkscape", "inkscape:label", "objects");
        root.appendChild(objectsGroup);
        for (SceneObject object : picture.objects()) {
            Element rect = doc.createElement("rect");
            objectsGroup.appendChild(rect);
            rect.setAttribute("id", object.getName(true));
            rect.setAttribute("x", String.valueOf(Math.round(object.getPoint().x - object.getScaleX() / 2)));
            rect.setAttribute("y", String.valueOf(Math.round(object.getPoint().y - object.getScaleY() / 2)));
            rect.setAttribute("width", String.valueOf(object.getScaleX()));
            rect.setAttribute("height", String.valueOf(object.getScaleY()));
            rect.setAttribute("vertex", "OBJECT");
            rect.setAttribute("style", "fill:none;stroke:#00ff00;stroke-opacity:1");
            this.exportAnnotations(rect, object);
        }
        Element relationsGroup = doc.createElement("relations");
        root.appendChild(relationsGroup);
        for (Relation relation : picture.relations()) {
            relationElement = doc.createElement("relation");
            relationsGroup.appendChild(relationElement);
            relationElement.setAttribute("from", relation.getSource().getName(true));
            relationElement.setAttribute("to", relation.getDestination().getName(true));
            relationElement.setAttribute("type", relation.getRelationName());
            this.exportAnnotations(relationElement, relation);
        }
        for (Edge edge : edges) {
            for (Segment segment : edge.getRelatedSegments()) {
                relationElement = doc.createElement("relation");
                relationsGroup.appendChild(relationElement);
                relationElement.setAttribute("from", segment.getName(true));
                relationElement.setAttribute("to", edge.getName(true));
                relationElement.setAttribute("type", "boundary");
            }
        }
        StringWriter out = new StringWriter();
        Transformer xform = null;
        try {
            xform = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(ExportSVGTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        xform.setOutputProperty("indent", "yes");
        xform.setOutputProperty("omit-xml-declaration", "no");
        try {
            xform.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (TransformerException ex) {
            Logger.getLogger(ExportSVGTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(filePath));
            output.write(out.toString());
            ((Writer)output).close();
        }
        catch (IOException ex) {
            Logger.getLogger(ExportSVGTask.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void exportAnnotations(Element element, Annotable annotable) {
        Map<String, Annotation> annotations = annotable.getAnnotationProxy().getAnnotations();
        for (Map.Entry<String, Annotation> entry : annotations.entrySet()) {
            element.setAttribute(entry.getKey(), entry.getValue().getValue());
        }
    }

    private Vector<Line> sortLines(Vector<Line> lines) {
        Vector<Line> ret = new Vector<Line>();
        Point lastPoint = null;
        while (ret.size() != lines.size()) {
            boolean lineAdded = false;
            for (Line line : lines) {
                if (ret.contains(line) || lastPoint != null && lastPoint != line.getPointA()) continue;
                ret.add(line);
                lastPoint = line.getPointB();
                lineAdded = true;
                break;
            }
            if (lineAdded) continue;
            JOptionPane.showMessageDialog(null, "Unexpected inconsistency: ExportSVGTask,java:228");
            return ret;
        }
        return ret;
    }

    private String repeatChar(char theChar, int times) {
        String ret = "";
        for (int c = 0; c < times; ++c) {
            ret = ret + theChar;
        }
        return ret;
    }

    @Override
    public String getDescription() {
        return "Exports the graph of the current picture to the SVG format";
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getCategory() {
        return "Tasks";
    }
}

