/*
 * Decompiled with CFR 0.152.
 */
package annotator.tasks;

import annotator.Picture;
import annotator.Project;
import annotator.graph.Edge;
import annotator.graph.Relation;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import annotator.tasks.Task;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ExportDotTask
extends Task {
    public String getName() {
        return "Export to DOT...";
    }

    public void launch(Project project, Picture picture) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File(picture.getFilename() + ".dot"));
        int result = fc.showSaveDialog(null);
        if (result != 0) {
            return;
        }
        String filePath = fc.getSelectedFile().getAbsolutePath();
        CopyOnWriteArraySet<Edge> edges = new CopyOnWriteArraySet<Edge>();
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(filePath));
            output.write("digraph Annotation {\n");
            output.write("node [shape=box];\n");
            for (Segment segment : picture.segments()) {
                output.write(segment.getName(true) + " [label=\"" + segment.getLabel() + "\"];\n");
                edges.addAll(segment.edges());
            }
            output.write("\n");
            output.write("node [shape=diamond]; \n");
            output.write("\n");
            for (Edge edge : edges) {
                output.write(edge.getName(true) + " [label=\"" + edge.getLabel() + "\"];\n");
            }
            for (Edge edge : picture.singleEdges()) {
                if (edges.contains(edge)) continue;
                output.write(edge.getName(true) + " [label=\"" + edge.getLabel() + "\"];\n");
            }
            output.write("\n");
            output.write("node [shape=circle]; \n");
            output.write("\n");
            for (SceneObject object : picture.objects()) {
                output.write(object.getName(true) + " [label=\"" + object.getLabel() + "\"];\n");
            }
            output.write("\n");
            output.write("edge [label=\"BOUNDARY\"];\n");
            output.write("\n");
            for (Edge edge : edges) {
                for (Segment segment : edge.getRelatedSegments()) {
                    output.write(edge.getName(true) + " -> " + segment.getName(true) + ";\n");
                }
            }
            output.write("\n");
            output.write("\n");
            for (Relation relation : picture.relations()) {
                output.write(relation.getSource().getName(true));
                output.write(" -> ");
                output.write(relation.getDestination().getName(true));
                String label = relation.getLabel();
                label = label.equals("") ? relation.getRelationName() : relation.getRelationName() + ";" + label;
                output.write(" [label=\"" + label + "\"];\n");
            }
            output.write("}");
            ((Writer)output).close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Could not open file.");
        }
    }

    public String getDescription() {
        return "Exports the graph of the current picture into DOT format";
    }

    public Icon getIcon() {
        return null;
    }

    public String getCategory() {
        return "Tasks";
    }
}

