/*
 * Decompiled with CFR 0.152.
 */
package annotator.graph;

import annotator.AnnotatorApp;
import annotator.GUI.AnnotatorView;
import annotator.GUI.ZoomedGraphics;
import annotator.PaintType;
import annotator.Picture;
import annotator.SerializableEx;
import annotator.annotations.Annotable;
import annotator.annotations.AnnotationProxy;
import annotator.annotations.AreaAnnotation;
import annotator.annotations.CentroidAnnotation;
import annotator.annotations.NameAnnotation;
import annotator.annotations.StringAnnotation;
import annotator.annotations.TextureTypeAnnotation;
import annotator.graph.Edge;
import annotator.graph.GraphNode;
import annotator.graph.InconsistentSegmentException;
import annotator.graph.Line;
import annotator.graph.PlacedEntity;
import annotator.graph.Point;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment
extends GraphNode
implements SerializableEx,
Annotable,
PlacedEntity {
    static final long serialVersionUID = 5024342787857921544L;
    Vector<Edge> edges = new Vector();
    private AnnotationProxy annotationProxy = new AnnotationProxy(this);

    public Vector<Edge> edges() {
        return this.edges;
    }

    public Vector<Line> getLines() {
        Vector<Line> lines = new Vector<Line>();
        for (Edge edge : this.edges) {
            lines.addAll(edge.getLines());
        }
        return lines;
    }

    public Segment(Picture picture) {
        super(picture);
    }

    public void paint(ZoomedGraphics graphics, PaintType paintType) {
        int zoom = graphics.getZoom();
        Graphics2D g2d = (Graphics2D)graphics.raw;
        if (paintType == PaintType.SELECTED) {
            g2d.setColor(Color.blue);
            g2d.setStroke(new BasicStroke(2.0f));
            java.awt.Point centroid = this.getSafeCentroid();
            g2d.drawLine(centroid.x * zoom - 5, centroid.y * zoom - 5, centroid.x * zoom + 5, centroid.y * zoom + 5);
            g2d.drawLine(centroid.x * zoom - 5, centroid.y * zoom + 5, centroid.x * zoom + 5, centroid.y * zoom - 5);
        }
        for (Edge edge : this.edges) {
            edge.paint(graphics, paintType);
        }
    }

    @Override
    public AnnotationProxy getAnnotationProxy() {
        return this.annotationProxy;
    }

    @Override
    public void defineAnnotations(AnnotationProxy proxy) {
        proxy.defineAnnotation("id", new NameAnnotation("Name", this));
        proxy.defineAnnotation("position", new CentroidAnnotation("Position", this));
        proxy.defineAnnotation("size", new AreaAnnotation("Size", this));
        proxy.defineAnnotation("feature_vector", new StringAnnotation("Feature Vector"));
        proxy.defineAnnotation("texture_type", new TextureTypeAnnotation("Texture Type"));
    }

    @Override
    public void afterUnserialize() {
        for (Edge edge : this.edges) {
            edge.afterUnserialize();
        }
    }

    public void initCache() {
        for (Edge edge : this.edges) {
            edge.initCache();
        }
    }

    protected Vector<Point> sortPoints() throws InconsistentSegmentException {
        Point firstPoint;
        Vector<Point> availablePoints = new Vector<Point>();
        Vector<Point> sortedPoints = new Vector<Point>();
        Vector<Line> lines = this.getLines();
        Vector<Line> usedLines = new Vector<Line>();
        for (Line line : lines) {
            if (!availablePoints.contains(line.pointA)) {
                availablePoints.add(line.pointA);
            }
            if (availablePoints.contains(line.pointB)) continue;
            availablePoints.add(line.pointB);
        }
        Point currentPoint = firstPoint = (Point)availablePoints.firstElement();
        Point lastPoint = null;
        sortedPoints.add(currentPoint);
        do {
            for (Line line : currentPoint.relatedLines) {
                if (usedLines.contains(line) || !line.getEdge().getRelatedSegments().contains(this)) continue;
                currentPoint = line.pointA == currentPoint ? line.pointB : line.pointA;
                usedLines.add(line);
                break;
            }
            if (currentPoint == lastPoint) {
                throw new InconsistentSegmentException();
            }
            lastPoint = currentPoint;
            sortedPoints.add(currentPoint);
        } while (currentPoint != firstPoint);
        return sortedPoints;
    }

    protected double areaRaw() throws InconsistentSegmentException {
        double area = 0.0;
        Vector<Point> sortedPoints = this.sortPoints();
        Point lastPoint = null;
        boolean firstRun = true;
        for (Point point : sortedPoints) {
            if (firstRun) {
                lastPoint = point;
                firstRun = false;
                continue;
            }
            area += (double)(lastPoint.x * point.y - point.x * lastPoint.y);
            lastPoint = point;
        }
        return area /= 2.0;
    }

    public double area() throws InconsistentSegmentException {
        return Math.abs(this.areaRaw());
    }

    public java.awt.Point centroid() throws InconsistentSegmentException {
        java.awt.Point centroid = new java.awt.Point(0, 0);
        Vector<Point> sortedPoints = this.sortPoints();
        Point lastPoint = null;
        boolean firstRun = true;
        for (Point point : sortedPoints) {
            if (firstRun) {
                lastPoint = point;
                firstRun = false;
                continue;
            }
            int k = lastPoint.x * point.y - point.x * lastPoint.y;
            centroid.x += (lastPoint.x + point.x) * k;
            centroid.y += (lastPoint.y + point.y) * k;
            lastPoint = point;
        }
        centroid.x = (int)((double)centroid.x / (6.0 * this.areaRaw()));
        centroid.y = (int)((double)centroid.y / (6.0 * this.areaRaw()));
        return centroid;
    }

    @Override
    public void destroy() {
        Vector _edges = (Vector)this.edges.clone();
        for (Edge edge : _edges) {
            edge.unassignFromSegment(this);
            if (!edge.getRelatedSegments().isEmpty()) continue;
            edge.destroy();
        }
        this.picture.segments().remove(this);
        this.picture.removeRelationsOf(this);
    }

    public String toString() {
        String name = this.annotationProxy.getAnnotations().get("id").getValue();
        if (!name.equals("")) {
            return "Segment: " + name;
        }
        return "Segment";
    }

    @Override
    public java.awt.Point getBasePoint() {
        return this.getSafeCentroid();
    }

    @Override
    public String getName(boolean includePrefix) {
        if (this.annotationProxy.getAnnotations().get("id") == null) {
            return null;
        }
        String name = this.annotationProxy.getAnnotations().get("id").getValue();
        if (includePrefix) {
            return "segment_" + name;
        }
        return name;
    }

    public String getLabel() {
        return this.annotationProxy.getLabel();
    }

    public void initName(Vector<Segment> segments) {
        int ordNumber = segments.size();
        String newName = "segment" + Integer.toString(ordNumber);
        while (this.nameTaken(segments, newName)) {
            newName = "segment" + Integer.toString(++ordNumber);
        }
        NameAnnotation nameAnnotation = (NameAnnotation)this.annotationProxy.getAnnotations().get("id");
        nameAnnotation.setValue(newName);
        for (Edge edge : this.edges) {
            edge.initName(((AnnotatorView)AnnotatorApp.getApplication().getMainView()).getCurrentPicture().allEdges());
        }
    }

    public boolean nameTaken(Vector<Segment> segments, String name) {
        for (Segment segment : segments) {
            if (segment.getName(false) == null || !segment.getName(false).equals(name) || segment == this) continue;
            return true;
        }
        return false;
    }

    public java.awt.Point getSafeCentroid() {
        java.awt.Point centroid;
        block2: {
            try {
                centroid = this.centroid();
            }
            catch (InconsistentSegmentException ex) {
                centroid = new java.awt.Point(0, 0);
                if (this.edges.firstElement() == null || this.edges.firstElement().getLines().isEmpty()) break block2;
                centroid = this.edges.firstElement().getLines().firstElement().getPointA();
            }
        }
        return centroid;
    }
}

