/*
 * Decompiled with CFR 0.152.
 */
package annotator.graph;

import annotator.GUI.ZoomedGraphics;
import annotator.ObjectCache;
import annotator.Picture;
import annotator.SerializableEx;
import annotator.annotations.Annotable;
import annotator.annotations.AnnotationProxy;
import annotator.annotations.NameAnnotation;
import annotator.annotations.ObjectPositionAnnotation;
import annotator.annotations.ObjectScaleAnnotation;
import annotator.annotations.ObjectTypeAnnotation;
import annotator.graph.GraphNode;
import annotator.graph.PlacedEntity;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneObject
extends GraphNode
implements SerializableEx,
Annotable,
PlacedEntity {
    static final long serialVersionUID = 4393479375960029954L;
    private AnnotationProxy annotationProxy;
    protected int x;
    protected int y;
    protected int scaleX;
    protected int scaleY;

    public SceneObject(Picture picture) {
        this(picture, 0, 0);
    }

    public SceneObject(Picture picture, int x, int y) {
        super(picture);
        this.init();
        this.x = x;
        this.y = y;
        this.scaleX = 20;
        this.scaleY = 20;
    }

    public void init() {
        this.annotationProxy = new AnnotationProxy(this);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(int scaleX) {
        this.scaleX = scaleX;
    }

    public int getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(int scaleY) {
        this.scaleY = scaleY;
    }

    @Override
    public void afterUnserialize() {
    }

    @Override
    public AnnotationProxy getAnnotationProxy() {
        return this.annotationProxy;
    }

    @Override
    public void defineAnnotations(AnnotationProxy proxy) {
        proxy.defineAnnotation("id", new NameAnnotation("Name", this));
        proxy.defineAnnotation("position", new ObjectPositionAnnotation("Position", this));
        proxy.defineAnnotation("scale", new ObjectScaleAnnotation("Scale", this));
        proxy.defineAnnotation("object_type", new ObjectTypeAnnotation("Object Type"));
    }

    public void paint(ZoomedGraphics graphics) {
        this.performPaint(graphics, Color.YELLOW);
        this.paintScale(graphics);
    }

    public void selectedPaint(ZoomedGraphics graphics) {
        this.performPaint(graphics, Color.BLUE);
        this.paintScale(graphics);
    }

    public void hoverPaint(ZoomedGraphics graphics) {
        this.performPaint(graphics, Color.GREEN);
        this.paintScale(graphics);
    }

    public void initCache() {
        ObjectCache.getObjectCache().add(this);
    }

    protected void performPaint(ZoomedGraphics graphics, Color discColor) {
        Graphics2D g = (Graphics2D)graphics.raw;
        int x = this.x * graphics.getZoom();
        int y = this.y * graphics.getZoom();
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(discColor);
        g.fillOval(x - 5, y - 5, 11, 11);
        g.setColor(Color.BLACK);
        g.drawOval(x - 5, y - 5, 11, 11);
        g.drawOval(x - 2, y - 2, 5, 5);
    }

    protected void paintScale(ZoomedGraphics graphics) {
        graphics.drawLine(this.x - this.scaleX / 2, this.y - this.scaleY / 2, this.x + this.scaleX / 2, this.y - this.scaleY / 2);
        graphics.drawLine(this.x - this.scaleX / 2, this.y + this.scaleY / 2, this.x + this.scaleX / 2, this.y + this.scaleY / 2);
        graphics.drawLine(this.x - this.scaleX / 2, this.y - this.scaleY / 2, this.x - this.scaleX / 2, this.y + this.scaleY / 2);
        graphics.drawLine(this.x + this.scaleX / 2, this.y - this.scaleY / 2, this.x + this.scaleX / 2, this.y + this.scaleY / 2);
    }

    public boolean isPointVertScaleHover(Point2D point) {
        return point.getX() > (double)(this.x - this.scaleX / 2 - 3) && point.getX() < (double)(this.x + this.scaleX / 2 + 3) && (Math.abs(point.getY() - (double)(this.y - this.scaleY / 2)) < 2.0 || Math.abs(point.getY() - (double)(this.y + this.scaleY / 2)) < 2.0);
    }

    public boolean isPointHorScaleHover(Point2D point) {
        return point.getY() > (double)(this.y - this.scaleY / 2 - 3) && point.getY() < (double)(this.y + this.scaleY / 2 + 3) && (Math.abs(point.getX() - (double)(this.x - this.scaleX / 2)) < 2.0 || Math.abs(point.getX() - (double)(this.x + this.scaleX / 2)) < 2.0);
    }

    public String toString() {
        String name = this.annotationProxy.getAnnotations().get("id").getValue();
        if (!name.equals("")) {
            return "Object: " + name;
        }
        return "Object";
    }

    @Override
    public Point getBasePoint() {
        return this.getPoint();
    }

    @Override
    public String getName(boolean includePrefix) {
        if (this.annotationProxy.getAnnotations().get("id") == null) {
            return null;
        }
        String name = this.annotationProxy.getAnnotations().get("id").getValue();
        if (includePrefix) {
            return "object_" + name;
        }
        return name;
    }

    public String getLabel() {
        return this.annotationProxy.getLabel();
    }

    public void initName(Vector<SceneObject> objects) {
        int ordNumber = objects.size();
        String newName = "object" + Integer.toString(ordNumber);
        while (this.nameTaken(objects, newName)) {
            newName = "object" + Integer.toString(++ordNumber);
        }
        NameAnnotation nameAnnotation = (NameAnnotation)this.annotationProxy.getAnnotations().get("id");
        nameAnnotation.setValue(newName);
    }

    public boolean nameTaken(Vector<SceneObject> objects, String name) {
        for (SceneObject object : objects) {
            if (object.getName(false) == null || !object.getName(false).equals(name) || object == this) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.picture.objects().remove(this);
        this.picture.removeRelationsOf(this);
    }
}

