/*
 * Decompiled with CFR 0.152.
 */
package annotator.graph;

import annotator.GUI.DisplayedRelationsModel;
import annotator.GUI.ZoomedGraphics;
import annotator.PaintType;
import annotator.Picture;
import annotator.SerializableEx;
import annotator.annotations.Annotable;
import annotator.annotations.AnnotationProxy;
import annotator.annotations.PositionAnnotation;
import annotator.graph.AdjacentRelation;
import annotator.graph.Edge;
import annotator.graph.GraphNode;
import annotator.graph.ImageNextToRelation;
import annotator.graph.InSegmentRelation;
import annotator.graph.Line;
import annotator.graph.PlacedEntity;
import annotator.graph.SceneNextToRelation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;

public abstract class Relation
extends GraphNode
implements SerializableEx,
Annotable {
    static final long serialVersionUID = -1911293909391751480L;
    protected AnnotationProxy annotationProxy = new AnnotationProxy(this);
    protected Annotable source;
    protected Annotable destination;

    public abstract boolean isDisplayed(DisplayedRelationsModel var1);

    public Relation(Picture picture, Annotable source, Annotable destination) {
        super(picture);
        this.source = source;
        this.destination = destination;
    }

    public AnnotationProxy getAnnotationProxy() {
        return this.annotationProxy;
    }

    public Annotable getDestination() {
        return this.destination;
    }

    public void setDestination(Annotable destination) {
        this.destination = destination;
    }

    public Annotable getSource() {
        return this.source;
    }

    public void setSource(Annotable source) {
        this.source = source;
    }

    public void paint(ZoomedGraphics graphics, PaintType paintType) {
        Graphics2D g2d = (Graphics2D)graphics.raw;
        PositionAnnotation sourcePositionAnnotation = (PositionAnnotation)((Object)this.source.getAnnotationProxy().getAnnotations().get("position"));
        PositionAnnotation destinationPositionAnnotation = (PositionAnnotation)((Object)this.destination.getAnnotationProxy().getAnnotations().get("position"));
        if (sourcePositionAnnotation != null && destinationPositionAnnotation != null) {
            Point sourcePosition = this.getSourcePosition();
            Point destinationPosition = this.getDestinationPosition(sourcePosition);
            if (this.source instanceof PlacedEntity) {
                sourcePosition = ((PlacedEntity)((Object)this.source)).getBasePoint();
            } else if (this.source instanceof Edge) {
                sourcePosition = ((Edge)this.source).getClosestPointTo(this.destination);
            } else {
                throw new UnsupportedOperationException("Invalid argument");
            }
            if (this.destination instanceof PlacedEntity) {
                destinationPosition = ((PlacedEntity)((Object)this.destination)).getBasePoint();
            } else if (this.destination instanceof Edge) {
                destinationPosition = ((Edge)this.destination).getClosestPointTo(sourcePosition);
            } else {
                throw new UnsupportedOperationException("Invalid argument");
            }
            g2d.setStroke(new BasicStroke(2.0f));
            switch (paintType) {
                case HOVER: {
                    g2d.setColor(Color.green);
                    break;
                }
                case SELECTED: {
                    g2d.setColor(Color.blue);
                    break;
                }
                case STANDARD: {
                    g2d.setColor(Color.red);
                }
            }
            graphics.drawLine(sourcePosition.x, sourcePosition.y, destinationPosition.x, destinationPosition.y);
            AffineTransform transformation = AffineTransform.getScaleInstance(graphics.getZoom(), graphics.getZoom());
            transformation.translate(destinationPosition.x, destinationPosition.y);
            if (destinationPosition != sourcePosition) {
                transformation.rotate(Math.atan2(destinationPosition.y - sourcePosition.y, destinationPosition.x - sourcePosition.x));
            }
            double invZoom = 1.0 / (double)graphics.getZoom();
            transformation.scale(invZoom, invZoom);
            Path2D.Double path = new Path2D.Double();
            path.moveTo(-7.0, -7.0);
            path.lineTo(0.0, 0.0);
            path.moveTo(-7.0, 7.0);
            path.lineTo(0.0, 0.0);
            g2d.draw(transformation.createTransformedShape(path));
        }
    }

    protected Point getSourcePosition() {
        Point sourcePosition = null;
        if (this.source instanceof PlacedEntity) {
            sourcePosition = ((PlacedEntity)((Object)this.source)).getBasePoint();
        } else if (this.source instanceof Edge) {
            sourcePosition = ((Edge)this.source).getClosestPointTo(this.destination);
        } else {
            throw new UnsupportedOperationException("Invalid argument");
        }
        return sourcePosition;
    }

    protected Point getDestinationPosition(Point sourcePosition) {
        Point destinationPosition = null;
        if (this.destination instanceof PlacedEntity) {
            destinationPosition = ((PlacedEntity)((Object)this.destination)).getBasePoint();
        } else if (this.destination instanceof Edge) {
            destinationPosition = ((Edge)this.destination).getClosestPointTo(sourcePosition);
        } else {
            throw new UnsupportedOperationException("Invalid argument");
        }
        return destinationPosition;
    }

    public boolean isPointHover(Point point, int zoom) {
        PositionAnnotation sourcePositionAnnotation = (PositionAnnotation)((Object)this.source.getAnnotationProxy().getAnnotations().get("position"));
        PositionAnnotation destinationPositionAnnotation = (PositionAnnotation)((Object)this.destination.getAnnotationProxy().getAnnotations().get("position"));
        if (sourcePositionAnnotation != null && destinationPositionAnnotation != null) {
            Point sourcePosition = this.getSourcePosition();
            Point destinationPosition = this.getDestinationPosition(sourcePosition);
            return Line.isPointHover(sourcePosition, destinationPosition, point, zoom);
        }
        return false;
    }

    public String getName(boolean includePrefix) {
        return "";
    }

    public String getRelationName() {
        if (this instanceof AdjacentRelation) {
            return "ADJACENT";
        }
        if (this instanceof ImageNextToRelation) {
            return "NEXT_TO_IMAGE";
        }
        if (this instanceof SceneNextToRelation) {
            return "NEXT_TO_SCENE";
        }
        if (this instanceof InSegmentRelation) {
            return "IN_SEGMENT";
        }
        return "?";
    }

    public String getLabel() {
        return this.annotationProxy.getLabel();
    }

    public void destroy() {
        this.picture.relations().remove(this);
    }
}

