/*
 * Decompiled with CFR 0.152.
 */
package annotator.graph;

import annotator.GUI.ZoomedGraphics;
import annotator.ObjectCache;
import annotator.SerializableEx;
import annotator.annotations.Annotable;
import annotator.annotations.AnnotationProxy;
import annotator.graph.Edge;
import annotator.graph.Line;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point
extends java.awt.Point
implements SerializableEx,
Annotable {
    static final long serialVersionUID = -413717008836117340L;
    private AnnotationProxy annotationProxy;
    protected Vector<Line> relatedLines;

    public void init() {
        this.relatedLines = new Vector();
        this.initCache();
    }

    public Point() {
        this.init();
    }

    public Point(int x, int y) {
        super(x, y);
        this.init();
    }

    public Point(java.awt.Point point) {
        super(point);
        this.init();
    }

    @Override
    public AnnotationProxy getAnnotationProxy() {
        return this.annotationProxy;
    }

    public void assignToLine(Line line) {
        this.relatedLines.add(line);
    }

    public void unassignFromLine(Line line) {
        this.relatedLines.remove(line);
    }

    public Vector<Line> getRelatedLines() {
        return this.relatedLines;
    }

    @Override
    public void defineAnnotations(AnnotationProxy proxy) {
    }

    void paint(ZoomedGraphics graphics) {
        Color prevColor = graphics.raw.getColor();
        graphics.raw.setColor(Color.yellow);
        graphics.raw.fillRect(this.x * graphics.getZoom() - 1, this.y * graphics.getZoom() - 1, 3, 3);
        graphics.raw.setColor(Color.black);
        graphics.raw.drawRect(this.x * graphics.getZoom() - 1, this.y * graphics.getZoom() - 1, 3, 3);
        graphics.raw.setColor(prevColor);
    }

    @Override
    public void afterUnserialize() {
    }

    public void initCache() {
        ObjectCache.getPointCache().add(this);
    }

    public void destroy() {
        while (ObjectCache.getPointCache().contains(this)) {
            ObjectCache.getPointCache().remove(this);
        }
    }

    public boolean isMarginal() {
        return this.isMarginal(null);
    }

    public boolean isMarginal(Edge edge) {
        Vector<Edge> oddEdges = new Vector<Edge>();
        for (Line line : this.relatedLines) {
            if (edge != null && line.edge != edge) continue;
            if (oddEdges.contains(line.edge)) {
                oddEdges.remove(line.edge);
                continue;
            }
            oddEdges.add(line.edge);
        }
        return !oddEdges.isEmpty();
    }

    public boolean isDiscardable() {
        CopyOnWriteArraySet<Edge> edges = new CopyOnWriteArraySet<Edge>();
        for (Line line : this.relatedLines) {
            edges.add(line.getEdge());
        }
        for (Edge edge : edges) {
            CopyOnWriteArraySet<Point> points = new CopyOnWriteArraySet<Point>();
            for (Line line : edge.getLines()) {
                if (line.pointA != this) {
                    points.add(line.pointA);
                }
                if (line.pointB == this) continue;
                points.add(line.pointB);
            }
            if (points.size() >= 2) continue;
            return false;
        }
        return true;
    }

    public boolean isPointHover(Point2D mousePoint, int zoom) {
        return Point.isPointHover(this, mousePoint, zoom);
    }

    public static boolean isPointHover(java.awt.Point point, Point2D mousePoint, int zoom) {
        int threshold = 10;
        return point.distance(mousePoint) < (double)(10.0f / (float)zoom);
    }

    @Override
    public String getName(boolean includePrefix) {
        return "";
    }
}

