/*
 * Decompiled with CFR 0.152.
 */
package annotator.graph;

import annotator.GUI.ZoomedGraphics;
import annotator.ObjectCache;
import annotator.PaintType;
import annotator.SerializableEx;
import annotator.graph.Edge;
import annotator.graph.Point;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Line
implements SerializableEx {
    static final long serialVersionUID = -4030598479729243161L;
    Point pointA;
    Point pointB;
    protected Edge edge = null;

    public Line(Point pointA, Point pointB) {
        this.setPointA(pointA);
        this.setPointB(pointB);
        ObjectCache.getLineCache().add(this);
    }

    public Point getPointA() {
        return this.pointA;
    }

    public void setPointA(Point pointA) {
        this.pointA = pointA;
        pointA.assignToLine(this);
    }

    public Point getPointB() {
        return this.pointB;
    }

    public void setPointB(Point pointB) {
        this.pointB = pointB;
        pointB.assignToLine(this);
    }

    public Edge getEdge() {
        return this.edge;
    }

    public void paint(ZoomedGraphics graphics, PaintType paintType) {
        int zoom = graphics.getZoom();
        Graphics2D g2d = (Graphics2D)graphics.raw;
        if (paintType != PaintType.STANDARD) {
            g2d.setStroke(new BasicStroke(2.0f));
        }
        if (paintType == PaintType.HOVER) {
            this.paint(graphics, Color.green);
        } else if (paintType == PaintType.SELECTED) {
            this.paint(graphics, Color.blue);
        } else {
            this.paint(graphics, Color.black);
        }
    }

    public void paint(ZoomedGraphics graphics, Color color) {
        Graphics2D g2d = (Graphics2D)graphics.raw;
        g2d.setColor(color);
        graphics.drawLine(this.pointA.x, this.pointA.y, this.pointB.x, this.pointB.y);
        this.pointA.paint(graphics);
    }

    public void afterUnserialize() {
        this.pointA.afterUnserialize();
        this.pointB.afterUnserialize();
    }

    public void initCache() {
        ObjectCache.getLineCache().add(this);
        this.pointA.initCache();
        this.pointB.initCache();
    }

    public boolean isPointHover(Point2D point, int zoom) {
        double threshold = 10.0;
        return (double)Math.round(this.getDistanceTo(point, null)) < 10.0 / (double)zoom;
    }

    public static boolean isPointHover(Point2D pointA, Point2D pointB, Point2D point, int zoom) {
        double threshold = 10.0;
        return (double)Math.round(Line.getDistanceTo(pointA, pointB, point, null)) < 10.0 / (double)zoom;
    }

    public double getDistanceTo(Point2D point, Point2D nearestPoint) {
        return Line.getDistanceTo(this.pointA, this.pointB, point, nearestPoint);
    }

    public static double getDistanceTo(Point2D pointA, Point2D pointB, Point2D point, Point2D nearestPoint) {
        if (pointA.getX() == pointB.getX() && pointA.getY() == pointB.getY()) {
            if (nearestPoint != null) {
                nearestPoint.setLocation(pointA.getX(), pointA.getY());
            }
            return Math.abs(pointA.distance(point));
        }
        Point2D pointLeft = pointA;
        Point2D pointRight = pointB;
        Point2D pointHigh = pointA;
        Point2D pointLow = pointB;
        if (pointA.getX() > pointB.getX()) {
            pointLeft = pointB;
            pointRight = pointA;
        }
        if (pointA.getY() > pointB.getY()) {
            pointHigh = pointB;
            pointLow = pointA;
        }
        int x1 = (int)pointA.getX();
        int y1 = (int)pointA.getY();
        int x2 = (int)pointB.getX();
        int y2 = (int)pointB.getY();
        double distance = ((double)(x2 - x1) * ((double)y1 - point.getY()) - ((double)x1 - point.getX()) * (double)(y2 - y1)) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        int vx = y2 - y1;
        int vy = -(x2 - x1);
        double vxu = (double)vx / Math.sqrt(vx * vx + vy * vy);
        double vyu = (double)vy / Math.sqrt(vx * vx + vy * vy);
        double nearestx = point.getX() - distance * vxu;
        double nearesty = point.getY() - distance * vyu;
        if (nearestx < pointLeft.getX()) {
            nearestx = pointLeft.getX();
            distance = pointLeft.distance(point);
        } else if (nearestx > pointRight.getX()) {
            nearestx = pointRight.getX();
            distance = pointRight.distance(point);
        }
        if (nearesty < pointHigh.getY()) {
            nearesty = pointHigh.getY();
            distance = pointHigh.distance(point);
        } else if (nearesty > pointLow.getY()) {
            nearesty = pointLow.getY();
            distance = pointLow.distance(point);
        }
        if (nearestPoint != null) {
            nearestPoint.setLocation(nearestx, nearesty);
        }
        return Math.abs(distance);
    }

    public void assignToEdge(Edge edge) {
        this.edge = edge;
        edge.getLines().add(this);
    }

    public void unassignFromEdge(Edge edge) {
        edge.getLines().remove(this);
    }

    public void destroy() {
        while (ObjectCache.getLineCache().contains(this)) {
            ObjectCache.getLineCache().remove(this);
        }
        this.pointA.unassignFromLine(this);
        this.pointB.unassignFromLine(this);
        if (this.pointA.getRelatedLines().isEmpty()) {
            this.pointA.destroy();
        }
        if (this.pointB.getRelatedLines().isEmpty()) {
            this.pointB.destroy();
        }
        this.edge.getLines().remove(this);
    }
}

