/*
 * Decompiled with CFR 0.152.
 */
package annotator.graph;

import annotator.GUI.ZoomedGraphics;
import annotator.PaintType;
import annotator.Picture;
import annotator.SerializableEx;
import annotator.annotations.Annotable;
import annotator.annotations.AnnotationProxy;
import annotator.annotations.EdgeLengthAnnotation;
import annotator.annotations.EdgePositionAnnotation;
import annotator.annotations.EdgeTypeAnnotation;
import annotator.annotations.NameAnnotation;
import annotator.graph.GraphNode;
import annotator.graph.Line;
import annotator.graph.PlacedEntity;
import annotator.graph.Point;
import annotator.graph.Segment;
import java.awt.geom.Point2D;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge
extends GraphNode
implements Annotable,
SerializableEx {
    static final long serialVersionUID = -4908342640684283444L;
    protected Vector<Segment> relatedSegments = new Vector();
    protected Vector<Line> lines = new Vector();
    protected AnnotationProxy annotationProxy = new AnnotationProxy(this);

    public Edge(Picture picture) {
        super(picture);
    }

    public Vector<Line> getLines() {
        return this.lines;
    }

    public void assignToSegment(Segment segment) {
        this.relatedSegments.add(segment);
        segment.edges().add(this);
    }

    public void unassignFromSegment(Segment segment) {
        this.relatedSegments.remove(segment);
        segment.edges().remove(this);
    }

    public Vector<Segment> getRelatedSegments() {
        return this.relatedSegments;
    }

    @Override
    public AnnotationProxy getAnnotationProxy() {
        return this.annotationProxy;
    }

    @Override
    public void defineAnnotations(AnnotationProxy proxy) {
        proxy.defineAnnotation("id", new NameAnnotation("Name", this));
        proxy.defineAnnotation("position", new EdgePositionAnnotation("Position", this));
        proxy.defineAnnotation("length", new EdgeLengthAnnotation("Length", this));
        proxy.defineAnnotation("edge_type", new EdgeTypeAnnotation("Type"));
    }

    public boolean hasCommonSegmentWith(Edge edge) {
        if (edge == this) {
            return true;
        }
        for (Segment segment : this.relatedSegments) {
            if (!edge.getRelatedSegments().contains(segment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        Vector<Line> linesToDestroy = new Vector<Line>();
        linesToDestroy.addAll(this.lines);
        for (Line line : linesToDestroy) {
            line.destroy();
        }
        for (Segment segment : this.relatedSegments) {
            segment.edges().remove(this);
        }
        this.picture.singleEdges().remove(this);
        this.picture.removeRelationsOf(this);
    }

    public void paint(ZoomedGraphics graphics, PaintType paintType) {
        if (this.lines.isEmpty()) {
            return;
        }
        for (Line line : this.lines) {
            line.paint(graphics, paintType);
        }
        this.lines.lastElement().getPointB().paint(graphics);
    }

    @Override
    public void afterUnserialize() {
        for (Line line : this.lines) {
            line.afterUnserialize();
        }
    }

    public void initCache() {
        for (Line line : this.lines) {
            line.initCache();
        }
    }

    public Point findOtherMarginalPoint(Point selectedPoint) {
        for (Line line : this.getLines()) {
            Point point = line.getPointA();
            if (point.isMarginal(this) && point != selectedPoint) {
                return point;
            }
            point = line.getPointB();
            if (!point.isMarginal(this) || point == selectedPoint) continue;
            return point;
        }
        return null;
    }

    public String toString() {
        String name = this.annotationProxy.getAnnotations().get("id").getValue();
        if (!name.equals("")) {
            return "Edge: " + name;
        }
        return "Edge";
    }

    public java.awt.Point getPosition() {
        Vector<Point> points = new Vector<Point>();
        java.awt.Point position = new java.awt.Point(0, 0);
        for (Line line : this.lines) {
            if (!points.contains(line.pointA)) {
                points.add(line.pointA);
            }
            if (points.contains(line.pointB)) continue;
            points.add(line.pointB);
        }
        for (Point point : points) {
            position.x += point.x;
            position.y += point.y;
        }
        position.x /= points.size();
        position.y /= points.size();
        return position;
    }

    @Override
    public String getName(boolean includePrefix) {
        if (this.annotationProxy.getAnnotations().get("id") == null) {
            return null;
        }
        String name = this.annotationProxy.getAnnotations().get("id").getValue();
        if (includePrefix) {
            return "edge_" + name;
        }
        return name;
    }

    public String getLabel() {
        return this.annotationProxy.getLabel();
    }

    public void initName(Vector<Edge> edges) {
        int ordNumber = edges.size();
        String newName = "edge" + Integer.toString(ordNumber);
        while (this.nameTaken(edges, newName)) {
            newName = "edge" + Integer.toString(++ordNumber);
        }
        NameAnnotation nameAnnotation = (NameAnnotation)this.annotationProxy.getAnnotations().get("id");
        nameAnnotation.setValue(newName);
    }

    public boolean nameTaken(Vector<Edge> edges, String name) {
        for (Edge edge : edges) {
            if (edge.getName(false) == null || !edge.getName(false).equals(name) || edge == this) continue;
            return true;
        }
        return false;
    }

    public java.awt.Point getClosestPointTo(Annotable annotable) {
        if (annotable instanceof PlacedEntity) {
            java.awt.Point basePoint = ((PlacedEntity)((Object)annotable)).getBasePoint();
            Vector<Point> points = this.getPoints();
            Point closestPoint = points.firstElement();
            for (Point point : points) {
                if (!(point.distance(basePoint) < closestPoint.distance(basePoint))) continue;
                closestPoint = point;
            }
            return closestPoint;
        }
        if (annotable instanceof Edge) {
            Edge otherEdge = (Edge)annotable;
            Vector<Point> points = this.getPoints();
            java.awt.Point otherClosestPoint = otherEdge.getLines().firstElement().pointA;
            Point pairedPoint = this.lines.firstElement().pointA;
            for (Point point : points) {
                java.awt.Point otherPoint = otherEdge.getClosestPointTo(point);
                if (!(otherPoint.distance(point) < otherClosestPoint.distance(pairedPoint))) continue;
                otherClosestPoint = otherPoint;
                pairedPoint = point;
            }
            java.awt.Point closestPoint = this.lines.firstElement().pointA;
            Point otherPairedPoint = otherEdge.getLines().firstElement().pointA;
            for (Point otherPoint : otherEdge.getPoints()) {
                java.awt.Point point = this.getClosestPointTo(otherPoint);
                if (!(point.distance(otherPoint) < closestPoint.distance(otherPairedPoint))) continue;
                closestPoint = point;
                otherPairedPoint = otherPoint;
            }
            if (otherClosestPoint.distance(pairedPoint) < closestPoint.distance(otherPairedPoint)) {
                return pairedPoint;
            }
            return closestPoint;
        }
        throw new UnsupportedOperationException("Invalid Argument");
    }

    public java.awt.Point getClosestPointTo(java.awt.Point point) {
        Point2D closestPoint = this.lines.firstElement().pointA;
        double shortestDistance = closestPoint.distance(point);
        for (Line line : this.lines) {
            Point2D.Double newClosestPoint;
            double newDistance = line.getDistanceTo(point, newClosestPoint = new Point2D.Double());
            if (!(newDistance < shortestDistance)) continue;
            closestPoint = newClosestPoint;
            shortestDistance = newDistance;
        }
        return new java.awt.Point((int)Math.round(((Point2D)closestPoint).getX()), (int)Math.round(((Point2D)closestPoint).getY()));
    }

    private Vector<Point> getPoints() {
        Vector<Point> points = new Vector<Point>();
        if (this.lines.isEmpty()) {
            return points;
        }
        for (Line line : this.lines) {
            points.add(line.pointA);
        }
        points.add(this.lines.lastElement().pointB);
        return points;
    }
}

