/*
 * Decompiled with CFR 0.152.
 */
package annotator.graph;

import annotator.annotations.Annotable;
import annotator.graph.CustomizableAnnotation;
import annotator.graph.Edge;
import annotator.graph.PlacedEntity;
import annotator.graph.Relation;
import java.awt.Point;

class DistanceAnnotation
extends CustomizableAnnotation {
    static final long serialVersionUID = 6289301107578390088L;
    private final Relation relation;

    public DistanceAnnotation(String name, Relation relation) {
        super(name);
        this.relation = relation;
    }

    public String getValue() {
        if (this.customized) {
            return this.customValue;
        }
        Annotable source = this.relation.getSource();
        Annotable destination = this.relation.getDestination();
        Point srcPoint = null;
        Point dstPoint = null;
        if (source instanceof PlacedEntity) {
            srcPoint = ((PlacedEntity)((Object)source)).getBasePoint();
        } else if (source instanceof Edge) {
            srcPoint = ((Edge)source).getClosestPointTo(destination);
        } else {
            throw new UnsupportedOperationException("Invalid argument");
        }
        if (destination instanceof PlacedEntity) {
            dstPoint = ((PlacedEntity)((Object)destination)).getBasePoint();
        } else if (destination instanceof Edge) {
            dstPoint = ((Edge)destination).getClosestPointTo(source);
        } else {
            throw new UnsupportedOperationException("Invalid argument");
        }
        return String.valueOf(srcPoint.distance(dstPoint));
    }
}

