/*
 * Decompiled with CFR 0.152.
 */
package annotator.annotations;

import annotator.AnnotatorApp;
import annotator.GUI.AnnotatorView;
import annotator.NameChangeNotifier;
import annotator.Picture;
import annotator.annotations.Annotable;
import annotator.annotations.StringAnnotation;
import annotator.graph.Edge;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import javax.swing.JOptionPane;

public class NameAnnotation
extends StringAnnotation {
    static final long serialVersionUID = -1234120723579001858L;
    protected final Annotable annotable;

    public NameAnnotation(String name, Annotable annotable) {
        super(name);
        this.annotable = annotable;
    }

    public void setValue(String value) {
        AnnotatorView mainView = (AnnotatorView)AnnotatorApp.getApplication().getMainView();
        Picture picture = mainView.getCurrentPicture();
        if (this.annotable instanceof Segment) {
            if (((Segment)this.annotable).nameTaken(picture.segments(), value)) {
                this.showNameConflictMessage();
                return;
            }
        } else if (this.annotable instanceof Edge) {
            if (((Edge)this.annotable).nameTaken(picture.allEdges(), value)) {
                this.showNameConflictMessage();
                return;
            }
        } else if (this.annotable instanceof SceneObject && ((SceneObject)this.annotable).nameTaken(picture.objects(), value)) {
            this.showNameConflictMessage();
            return;
        }
        super.setValue(value);
        NameChangeNotifier.getInstance().notifyObservers();
    }

    private void showNameConflictMessage() {
        JOptionPane.showMessageDialog(AnnotatorApp.getApplication().getMainFrame(), "This name is already taken");
    }
}

