/*
 * Decompiled with CFR 0.152.
 */
package annotator.annotations;

import annotator.graph.CustomizableAnnotation;
import annotator.graph.Edge;
import annotator.graph.Line;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class EdgeLengthAnnotation
extends CustomizableAnnotation {
    static final long serialVersionUID = 9043371151320448575L;
    protected Edge edge;

    public EdgeLengthAnnotation(String name, Edge edge) {
        super(name);
        this.edge = edge;
    }

    public String getValue() {
        if (this.customized) {
            return this.customValue;
        }
        DecimalFormat fmt = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = fmt.getDecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(' ');
        decimalFormatSymbols.setDecimalSeparator('.');
        fmt.setDecimalFormatSymbols(decimalFormatSymbols);
        double length = 0.0;
        for (Line line : this.edge.getLines()) {
            length += Math.sqrt(Math.pow(line.getPointB().getX() - line.getPointA().getX(), 2.0) + Math.pow(line.getPointB().getY() - line.getPointA().getY(), 2.0));
        }
        return fmt.format(length);
    }
}

