/*
 * Decompiled with CFR 0.152.
 */
package annotator.annotations;

import annotator.annotations.Annotable;
import annotator.graph.CustomizableAnnotation;
import annotator.graph.Edge;
import annotator.graph.PlacedEntity;
import annotator.graph.Relation;
import java.awt.Point;

public class DirectionAnnotation
extends CustomizableAnnotation {
    private final Relation relation;

    public DirectionAnnotation(String name, Relation relation) {
        super(name);
        this.relation = relation;
    }

    public String getValue() {
        if (this.customized) {
            return this.customValue;
        }
        Annotable source = this.relation.getSource();
        Annotable destination = this.relation.getDestination();
        Point srcPoint = null;
        Point dstPoint = null;
        if (source instanceof PlacedEntity) {
            srcPoint = ((PlacedEntity)((Object)source)).getBasePoint();
        } else if (source instanceof Edge) {
            srcPoint = ((Edge)source).getClosestPointTo(destination);
        } else {
            throw new UnsupportedOperationException("Invalid argument");
        }
        if (destination instanceof PlacedEntity) {
            dstPoint = ((PlacedEntity)((Object)destination)).getBasePoint();
        } else if (destination instanceof Edge) {
            dstPoint = ((Edge)destination).getClosestPointTo(source);
        } else {
            throw new UnsupportedOperationException("Invalid argument");
        }
        double direction = -Math.toDegrees(Math.atan2(dstPoint.y - srcPoint.y, dstPoint.x - srcPoint.x));
        if (direction < 0.0) {
            direction = 360.0 + direction;
        }
        return String.valueOf(direction);
    }
}

