/*
 * Decompiled with CFR 0.152.
 */
package annotator.annotations;

import annotator.annotations.PositionAnnotation;
import annotator.graph.CustomizableAnnotation;
import annotator.graph.InconsistentSegmentException;
import annotator.graph.Segment;
import java.awt.Point;

public class CentroidAnnotation
extends CustomizableAnnotation
implements PositionAnnotation {
    protected Segment segment;

    public CentroidAnnotation(String name, Segment segment) {
        super(name);
        this.segment = segment;
    }

    public String getValue() {
        if (this.customized) {
            return this.customValue;
        }
        try {
            Point centroid = this.segment.centroid();
            return centroid.x + ", " + centroid.y;
        }
        catch (InconsistentSegmentException ex) {
            return "{Inconsistent segment}";
        }
    }

    public Point getPosition() {
        return this.segment.getSafeCentroid();
    }
}

