/*
 * Decompiled with CFR 0.152.
 */
package annotator.annotations;

import annotator.graph.CustomizableAnnotation;
import annotator.graph.InconsistentSegmentException;
import annotator.graph.Segment;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class AreaAnnotation
extends CustomizableAnnotation {
    protected Segment segment;

    public AreaAnnotation(String name, Segment segment) {
        super(name);
        this.segment = segment;
    }

    public String getValue() {
        if (this.customized) {
            return this.customValue;
        }
        DecimalFormat fmt = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = fmt.getDecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(' ');
        decimalFormatSymbols.setDecimalSeparator('.');
        fmt.setDecimalFormatSymbols(decimalFormatSymbols);
        try {
            return fmt.format(this.segment.area());
        }
        catch (InconsistentSegmentException ex) {
            return "{Inconsistent segment}";
        }
    }

    public void importValue(String newValue) {
        this.customized = true;
        this.customValue = newValue;
    }
}

