/*
 * Decompiled with CFR 0.152.
 */
package annotator.annotations;

import annotator.annotations.Annotable;
import annotator.annotations.Annotation;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AnnotationsTableModel
extends AbstractTableModel {
    static final String[] columnNames = new String[]{"Name", "Value"};
    protected Annotable annotable;
    protected Vector<Annotation> annotations;

    public AnnotationsTableModel(Annotable annotable) {
        this.annotable = annotable;
        this.annotations = new Vector<Annotation>(annotable.getAnnotationProxy().getAnnotations().values());
    }

    public int getRowCount() {
        return this.annotations.size();
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.annotations.get(rowIndex).getName();
        }
        return this.annotations.get(rowIndex).getValue();
    }

    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 0) {
            return null;
        }
        return this.annotations.get(row).getCellEditor();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.annotations.get(rowIndex).isEditable();
    }

    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return;
        }
        this.annotations.get(rowIndex).update(newValue);
    }
}

