/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Util {
    public static String getRelativePath(String fromPath, String toPath) throws Exception {
        int i;
        String[] fromPathStack = Util.getPathStack(fromPath);
        String[] toPathStack = Util.getPathStack(toPath);
        if (0 < toPathStack.length && 0 < fromPathStack.length) {
            if (!fromPathStack[0].equals(toPathStack[0])) {
                return Util.getPath(Arrays.asList(toPathStack));
            }
        } else {
            return Util.getPath(Arrays.asList(toPathStack));
        }
        int minLength = Math.min(fromPathStack.length, toPathStack.length);
        for (int same = 1; same < minLength && fromPathStack[same].equals(toPathStack[same]); ++same) {
        }
        ArrayList<String> relativePathStack = new ArrayList<String>();
        for (i = same; i < fromPathStack.length; ++i) {
            relativePathStack.add("..");
        }
        for (i = same; i < toPathStack.length; ++i) {
            relativePathStack.add(toPathStack[i]);
        }
        return Util.getPath(relativePathStack);
    }

    protected static String[] getPathStack(String path) {
        String normalizedPath = path.replace(File.separatorChar, '/');
        return normalizedPath.split("/");
    }

    public static String getPath(List pathStack) {
        return Util.getPath(pathStack, '/');
    }

    protected static String getPath(List pathStack, char separatorChar) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = pathStack.iterator();
        if (iter.hasNext()) {
            buffer.append(iter.next());
        }
        while (iter.hasNext()) {
            buffer.append(separatorChar);
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    protected static String getParentPath(String path) {
        String separator = File.separator;
        int index = path.lastIndexOf(separator);
        return path.substring(0, index);
    }
}

