/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import annotator.Picture;
import annotator.SerializableEx;
import annotator.Util;
import com.thoughtworks.xstream.XStream;
import java.beans.XMLEncoder;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements SerializableEx {
    static final long serialVersionUID = 7721725090313787885L;
    protected ArrayList<Picture> pictures = new ArrayList();
    protected String Filename = null;

    public ArrayList<Picture> Pictures() {
        return this.pictures;
    }

    public void SetPictures(ArrayList<Picture> pictures) {
        this.pictures = pictures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String Filename) {
        Object file = null;
        FileOutputStream fout = null;
        Object oos = null;
        FilterOutputStream bos = null;
        PrintStream ps = null;
        XMLEncoder encoder = null;
        boolean result = true;
        for (Picture picture : this.Pictures()) {
            picture.relativize(Util.getParentPath(Filename));
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Project.class.getClassLoader());
        try {
            fout = new FileOutputStream(Filename);
            ps = new PrintStream(fout);
            XStream xstream = new XStream();
            ps.print(xstream.toXML(this));
            this.Filename = Filename;
        }
        catch (Exception exception) {
            result = false;
        }
        finally {
            if (encoder != null) {
                encoder.close();
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex) {}
            }
            if (ps != null) {
                ps.close();
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ex) {}
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return result;
    }

    public boolean save() {
        return this.save(this.Filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project load(String Filename) {
        Project project = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(Filename);
            XStream xstream = new XStream();
            project = (Project)xstream.fromXML(fileInputStream);
            project.setFileName(Filename);
        }
        catch (Exception ex) {
            Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (project != null) {
            project.afterUnserialize();
        }
        return project;
    }

    public String getFilename() {
        return this.Filename;
    }

    private void setFileName(String Filename) {
        this.Filename = Filename;
    }

    @Override
    public void afterUnserialize() {
        for (Picture picture : this.pictures) {
            picture.absolutize(this.getPath());
            picture.afterUnserialize();
        }
    }

    public String getPath() {
        return Util.getParentPath(this.Filename);
    }
}

