/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import annotator.SerializableEx;
import annotator.Util;
import annotator.annotations.Annotable;
import annotator.graph.Edge;
import annotator.graph.Relation;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Picture
implements SerializableEx {
    protected String fullPath;
    protected String relativePath;
    protected String filename;
    protected Vector<Segment> segments;
    protected Vector<SceneObject> objects;
    protected Vector<Edge> singleEdges;
    protected Vector<Relation> relations;
    static final long serialVersionUID = -207556359106197785L;

    public Picture(File file, String projectPath) {
        this.relativePath = this.fullPath = file.getAbsolutePath();
        this.filename = file.getName();
        this.segments = new Vector();
        this.objects = new Vector();
        this.singleEdges = new Vector();
        this.relations = new Vector();
    }

    public Vector<Segment> segments() {
        return this.segments;
    }

    public Vector<SceneObject> objects() {
        return this.objects;
    }

    public Vector<Edge> singleEdges() {
        return this.singleEdges;
    }

    public Vector<Relation> relations() {
        return this.relations;
    }

    public Vector<Edge> allEdges() {
        Vector<Edge> edges = new Vector<Edge>();
        edges.addAll(this.singleEdges);
        for (Segment segment : this.segments) {
            edges.addAll(segment.edges());
        }
        return edges;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String path) {
        this.relativePath = path;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    @Override
    public void afterUnserialize() {
        for (Segment segment : this.segments) {
            segment.afterUnserialize();
        }
    }

    public void initCache() {
        for (Segment segment : this.segments) {
            segment.initCache();
        }
        for (Edge edge : this.singleEdges) {
            edge.initCache();
        }
        for (SceneObject object : this.objects) {
            object.initCache();
        }
    }

    public void removeRelationsOf(Annotable annotable) {
        Vector<Relation> relationsForDeletion = new Vector<Relation>();
        for (Relation relation : this.relations()) {
            if (relation.getSource() != annotable && relation.getDestination() != annotable) continue;
            relationsForDeletion.add(relation);
        }
        for (Relation relation : relationsForDeletion) {
            relation.destroy();
        }
    }

    public void relativize(String projectPath) {
        try {
            this.relativePath = Util.getRelativePath(projectPath, this.fullPath);
        }
        catch (Exception ex) {
            this.relativePath = this.fullPath;
        }
    }

    public void absolutize(String path) {
        File file = new File(path + "/" + this.relativePath);
        if (file.exists()) {
            this.fullPath = file.getAbsolutePath();
            return;
        }
        File fileAbsolute;
        while (!(fileAbsolute = new File(this.fullPath)).exists()) {
            int result = JOptionPane.showConfirmDialog(null, "Can not find image file: " + this.relativePath + "\nTried both expected locations:\n" + file.getAbsolutePath() + "\n" + fileAbsolute.getAbsolutePath() + "\n\nDo you want to specify new location now ?", "Image file not found", 0, 3);
            if (result == 1) {
                return;
            }
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            result = fc.showOpenDialog(null);
            if (result != 0) continue;
            this.fullPath = fc.getSelectedFile().getAbsolutePath();
        }
        return;
    }
}

