/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import annotator.graph.Line;
import annotator.graph.Point;
import annotator.graph.SceneObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCache<C> {
    protected static ObjectCache<Line> lineCache;
    protected static ObjectCache<Point> pointCache;
    protected static ObjectCache<SceneObject> objectCache;
    protected Set<C> cache = new CopyOnWriteArraySet<C>();

    public static void clear() {
        ObjectCache.getLineCache().clear();
        ObjectCache.getPointCache().clear();
        ObjectCache.getObjectCache().clear();
    }

    public static Set<Line> getLineCache() {
        if (lineCache == null) {
            lineCache = new ObjectCache();
        }
        return ObjectCache.lineCache.cache;
    }

    public static Set<Point> getPointCache() {
        if (pointCache == null) {
            pointCache = new ObjectCache();
        }
        return ObjectCache.pointCache.cache;
    }

    public static Set<SceneObject> getObjectCache() {
        if (objectCache == null) {
            objectCache = new ObjectCache();
        }
        return ObjectCache.objectCache.cache;
    }
}

