/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI.tools;

import annotator.GUI.ViewPort;
import annotator.GUI.tools.ToolListener;
import annotator.Picture;
import annotator.annotations.Annotable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public abstract class Tool {
    private ToolListener eventListener;
    protected ActionMap actionMap;
    protected InputMap inputMap;
    protected Picture picture;
    protected Vector<KeyStroke> keyStrokes = new Vector();
    protected Map<Integer, AbstractAction> actions = new TreeMap<Integer, AbstractAction>();
    protected int actionCounter = 0;
    protected boolean suggestsRelationSelect = false;
    protected Annotable suggestedSelection = null;

    public void onMousePressed(MouseEvent evt, int zoom) {
    }

    public void onMouseReleased(MouseEvent evt, int zoom) {
    }

    public void onPaint(ViewPort.CustomPaintEvent evt) {
    }

    public void onKeyPressed(KeyEvent evt) {
    }

    public void onMouseMoved(MouseEvent evt, int zoom) {
    }

    public void onMouseDragged(MouseEvent evt, int zoom) {
    }

    public void onAbort() {
    }

    public Tool(ToolListener listener, ActionMap actionMap, InputMap inputMap, Picture picture) {
        this.eventListener = listener;
        this.actionMap = actionMap;
        this.inputMap = inputMap;
        this.picture = picture;
    }

    public Annotable getSuggestedSelection() {
        return this.suggestedSelection;
    }

    public void suggestSelection(Annotable suggestedSelection) {
    }

    public boolean suggestsRelationSelect() {
        return this.suggestsRelationSelect;
    }

    protected void quitTool() {
        for (int i = 0; i <= this.actionCounter; ++i) {
            this.actionMap.remove("tool_" + i);
        }
        for (KeyStroke keyStroke : this.keyStrokes) {
            this.inputMap.remove(keyStroke);
        }
        this.eventListener.onToolQuit(this);
    }

    public void abortTool() {
        this.onAbort();
        this.quitTool();
    }

    protected void fireCursorToggle(boolean showCursor) {
        this.eventListener.onToolCursorToggle(showCursor);
    }

    protected void fireQueryRepaint() {
        this.eventListener.onToolQueryRepaint();
    }

    protected void fireSelectionChanged(Object selection) {
        this.eventListener.onToolSelectionChanged(selection);
    }

    protected void registerKeystroke(KeyStroke keyStroke, AbstractAction abstractAction) {
        this.actions.put(this.actionCounter, abstractAction);
        this.keyStrokes.add(keyStroke);
        this.actionMap.put("tool_" + this.actionCounter, abstractAction);
        this.inputMap.put(keyStroke, "tool_" + this.actionCounter);
        ++this.actionCounter;
    }

    public static KeyStroke getKeyStroke() {
        return null;
    }
}

