/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI.tools;

import annotator.GUI.ViewPort;
import annotator.GUI.tools.KeyStrokeCommand;
import annotator.GUI.tools.Tool;
import annotator.GUI.tools.ToolListener;
import annotator.ObjectCache;
import annotator.PaintType;
import annotator.Picture;
import annotator.graph.Edge;
import annotator.graph.Line;
import annotator.graph.Point;
import annotator.graph.Segment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

@KeyStrokeCommand(value="control E")
public class SplitEdgeTool
extends Tool {
    protected boolean shiftDown = false;
    protected boolean ctrlDown = false;
    protected Point hoverPoint = null;
    protected Line hoverLine = null;
    protected Edge hoverEdge = null;
    protected Edge selectedEdge = null;
    protected Vector<Point> splitPoints = new Vector();
    protected Vector<Vector<Line>> subregions = new Vector();
    protected ArrayList<Color> colors = new ArrayList();

    public SplitEdgeTool(ToolListener listener, ActionMap actionMap, InputMap inputMap, Picture picture) {
        super(listener, actionMap, inputMap, picture);
        this.registerKeystroke(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SplitEdgeTool.this.confirmSplit();
            }
        });
        this.registerKeystroke(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SplitEdgeTool.this.cancelSplit();
            }
        });
        this.colors.add(Color.blue);
        this.colors.add(Color.red);
        this.colors.add(Color.cyan);
        this.colors.add(Color.green);
        this.colors.add(Color.yellow);
        this.colors.add(Color.white);
        this.colors.add(Color.orange);
        this.colors.add(Color.pink);
        this.fireCursorToggle(true);
    }

    public void onMouseMoved(MouseEvent evt, int zoom) {
        this.shiftDown = evt.isShiftDown();
        this.ctrlDown = evt.isControlDown();
        Point newHoverPoint = null;
        boolean toBeRepainted = false;
        for (Point point : ObjectCache.getPointCache()) {
            if (Math.abs(evt.getX() / zoom - point.x) >= 10 || Math.abs(evt.getY() / zoom - point.y) >= 10) continue;
            newHoverPoint = point;
        }
        if (this.hoverPoint != newHoverPoint) {
            toBeRepainted = true;
        }
        this.hoverPoint = newHoverPoint;
        Edge newHoverEdge = null;
        if (this.hoverPoint == null) {
            for (Line line : ObjectCache.getLineCache()) {
                if (!line.isPointHover(new java.awt.Point(evt.getX() / zoom, evt.getY() / zoom), zoom)) continue;
                newHoverEdge = line.getEdge();
                this.hoverLine = line;
            }
        }
        if (this.hoverEdge != newHoverEdge) {
            toBeRepainted = true;
        }
        this.hoverEdge = newHoverEdge;
        if (toBeRepainted) {
            this.fireQueryRepaint();
        }
    }

    public void onMousePressed(MouseEvent evt, int zoom) {
        if (this.selectedEdge == null && this.hoverEdge != null) {
            this.selectedEdge = this.hoverEdge;
            this.subregions.add(this.selectedEdge.getLines());
            this.fireQueryRepaint();
        } else if (this.selectedEdge != null && this.hoverPoint != null && !this.splitPoints.contains(this.hoverPoint)) {
            this.splitPoints.add(this.hoverPoint);
            this.updateSubregions();
            this.fireQueryRepaint();
        }
    }

    public void onPaint(ViewPort.CustomPaintEvent evt) {
        int zoom = evt.graphics.getZoom();
        Graphics2D g2d = (Graphics2D)evt.graphics.raw;
        Iterator<Color> colorIterator = this.colors.iterator();
        Color color = colorIterator.next();
        for (Vector<Line> subedge : this.subregions) {
            for (Line line : subedge) {
                line.paint(evt.graphics, color);
            }
            if (!colorIterator.hasNext()) {
                colorIterator = this.colors.iterator();
            }
            color = colorIterator.next();
        }
        for (Point point : this.splitPoints) {
            g2d.setColor(Color.green);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawOval(point.x * zoom - 5, point.y * zoom - 5, 11, 11);
        }
        if (this.hoverPoint != null && this.selectedEdge != null) {
            g2d.setColor(Color.red);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawOval(this.hoverPoint.x * zoom - 5, this.hoverPoint.y * zoom - 5, 11, 11);
        }
        if (this.hoverEdge != null && this.selectedEdge == null) {
            this.hoverEdge.paint(evt.graphics, PaintType.HOVER);
        }
    }

    private void updateSubregions() {
        this.subregions.clear();
        Vector<Line> currentSubregion = new Vector<Line>();
        this.subregions.add(currentSubregion);
        Point point = this.splitPoints.firstElement();
        do {
            Line line;
            if ((line = this.getline(point)) == null) {
                point = this.selectedEdge.findOtherMarginalPoint(point);
                currentSubregion = new Vector();
                this.subregions.add(currentSubregion);
                continue;
            }
            currentSubregion.add(line);
            point = line.getPointB();
            if (!this.splitPoints.contains(point) || point == this.splitPoints.firstElement()) continue;
            currentSubregion = new Vector();
            this.subregions.add(currentSubregion);
        } while (point != this.splitPoints.firstElement());
    }

    private Line getline(Point point) {
        Vector<Line> relatedLines = point.getRelatedLines();
        for (Line line : relatedLines) {
            if (line.getPointA() != point || line.getEdge() != this.selectedEdge) continue;
            return line;
        }
        return null;
    }

    private void cancelSplit() {
        this.quitTool();
    }

    private void confirmSplit() {
        Vector<Segment> relatedSegments = new Vector<Segment>();
        relatedSegments.addAll(this.selectedEdge.getRelatedSegments());
        for (Vector<Line> subregion : this.subregions) {
            if (subregion.isEmpty()) continue;
            Edge subedge = new Edge(this.picture);
            for (Line line : subregion) {
                line.unassignFromEdge(this.selectedEdge);
                line.assignToEdge(subedge);
            }
            for (Segment segments : relatedSegments) {
                subedge.assignToSegment(segments);
            }
            subedge.initName(this.picture.allEdges());
        }
        for (Segment segments : relatedSegments) {
            this.selectedEdge.unassignFromSegment(segments);
        }
        this.selectedEdge.destroy();
        this.quitTool();
    }
}

