/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI.tools;

import annotator.GUI.ViewPort;
import annotator.GUI.tools.KeyStrokeCommand;
import annotator.GUI.tools.Tool;
import annotator.GUI.tools.ToolListener;
import annotator.ObjectCache;
import annotator.PaintType;
import annotator.Picture;
import annotator.annotations.Annotable;
import annotator.graph.Edge;
import annotator.graph.Line;
import annotator.graph.Point;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;

@KeyStrokeCommand(value="E")
public class SelectTool
extends Tool {
    protected Line hoverLine = null;
    protected Point hoverPoint = null;
    protected Edge hoverEdge = null;
    protected Edge selectedEdge = null;
    protected Segment selectedSegment = null;
    protected SceneObject hoverObject = null;
    protected SceneObject selectedObject = null;
    protected boolean ctrlDown = false;
    protected boolean shiftDown = false;
    protected boolean scalingObjectVertical = false;
    protected boolean scalingObjectHorizontal = false;

    public SelectTool(ToolListener listener, ActionMap actionMap, InputMap inputMap, Picture picture) {
        super(listener, actionMap, inputMap, picture);
        this.fireCursorToggle(false);
    }

    public void onMousePressed(MouseEvent evt, int zoom) {
        this.onMouseMoved(evt, zoom);
        if (this.hoverPoint != null && evt.isControlDown()) {
            Vector<Line> linesA = new Vector<Line>();
            Vector<Line> linesB = new Vector<Line>();
            for (Line line : this.hoverPoint.getRelatedLines()) {
                if (this.hoverPoint == line.getPointA()) {
                    linesA.add(line);
                    continue;
                }
                if (this.hoverPoint == line.getPointB()) {
                    linesB.add(line);
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Unexpected inconsistency (Selector.java:67)");
            }
            for (Line lineA : linesA) {
                Line matchingLineB = null;
                for (Line lineB : linesB) {
                    if (!lineB.getEdge().hasCommonSegmentWith(lineA.getEdge())) continue;
                    matchingLineB = lineB;
                    break;
                }
                if (matchingLineB != null) {
                    linesB.remove(matchingLineB);
                    lineA.setPointA(matchingLineB.getPointA());
                    matchingLineB.destroy();
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Unexpected inconsistency (Selector.java:85)");
            }
            this.hoverPoint.destroy();
            this.hoverPoint = null;
            this.fireQueryRepaint();
        } else if (this.hoverObject != null) {
            if (this.selectedObject != this.hoverObject) {
                this.selectedObject = this.hoverObject;
                this.selectedSegment = null;
                this.selectedEdge = null;
                this.fireQueryRepaint();
                this.fireSelectionChanged(this.selectedObject);
            }
        } else if (this.hoverEdge != null) {
            if (evt.isShiftDown()) {
                Point newPoint = new Point(evt.getX() / zoom, evt.getY() / zoom);
                Point secondPoint = this.hoverLine.getPointB();
                this.hoverLine.setPointB(newPoint);
                secondPoint.unassignFromLine(this.hoverLine);
                Line newLine = new Line(newPoint, secondPoint);
                newLine.assignToEdge(this.hoverEdge);
            } else {
                if (this.selectedSegment != null && this.selectedSegment.edges().contains(this.hoverEdge) || this.hoverEdge.getRelatedSegments().isEmpty()) {
                    if (this.selectedEdge != this.hoverEdge) {
                        this.selectedEdge = this.hoverEdge;
                        this.fireQueryRepaint();
                        this.fireSelectionChanged(this.selectedEdge);
                        return;
                    }
                    if (this.hoverEdge.getRelatedSegments().isEmpty()) {
                        return;
                    }
                }
                this.selectedSegment = this.hoverEdge.getRelatedSegments().firstElement();
                this.selectedEdge = null;
                this.selectedObject = null;
                this.fireQueryRepaint();
                this.fireSelectionChanged(this.selectedSegment);
            }
        }
    }

    public void onMouseMoved(MouseEvent evt, int zoom) {
        this.shiftDown = evt.isShiftDown();
        this.ctrlDown = evt.isControlDown();
        Point2D.Double mousePoint = new Point2D.Double((double)evt.getX() / (double)zoom, (double)evt.getY() / (double)zoom);
        Point newHoverPoint = null;
        boolean toBeRepainted = false;
        for (Point point : ObjectCache.getPointCache()) {
            if (!point.isPointHover(mousePoint, zoom) || this.ctrlDown && (point.isMarginal() || !point.isDiscardable())) continue;
            newHoverPoint = point;
        }
        if (this.hoverPoint != newHoverPoint) {
            toBeRepainted = true;
        }
        this.hoverPoint = newHoverPoint;
        SceneObject newHoverObject = null;
        for (SceneObject object : ObjectCache.getObjectCache()) {
            if (!Point.isPointHover(object.getPoint(), mousePoint, zoom)) continue;
            newHoverObject = object;
        }
        if (this.hoverObject != newHoverObject) {
            toBeRepainted = true;
        }
        this.hoverObject = newHoverObject;
        Edge newHoverEdge = null;
        if (this.hoverPoint == null) {
            for (Line line : ObjectCache.getLineCache()) {
                if (!line.isPointHover(mousePoint, zoom)) continue;
                newHoverEdge = line.getEdge();
                this.hoverLine = line;
            }
        }
        if (this.hoverEdge != newHoverEdge) {
            toBeRepainted = true;
        }
        this.hoverEdge = newHoverEdge;
        this.scalingObjectHorizontal = false;
        this.scalingObjectVertical = false;
        if (this.selectedObject != null) {
            if (this.selectedObject.isPointVertScaleHover(mousePoint)) {
                this.scalingObjectVertical = true;
                evt.getComponent().setCursor(Cursor.getPredefinedCursor(8));
            }
            if (this.selectedObject.isPointHorScaleHover(mousePoint)) {
                this.scalingObjectHorizontal = true;
                evt.getComponent().setCursor(Cursor.getPredefinedCursor(11));
            }
        }
        if (!this.scalingObjectHorizontal && !this.scalingObjectVertical) {
            evt.getComponent().setCursor(Cursor.getDefaultCursor());
        } else {
            this.hoverPoint = null;
            this.hoverEdge = null;
            this.hoverLine = null;
            this.hoverObject = null;
        }
        if (evt.isShiftDown() && this.hoverEdge != null) {
            this.fireCursorToggle(true);
        } else {
            this.fireCursorToggle(false);
        }
        if (toBeRepainted) {
            this.fireQueryRepaint();
        }
    }

    public void onMouseDragged(MouseEvent evt, int zoom) {
        if (this.scalingObjectHorizontal) {
            this.selectedObject.setScaleX(2 * Math.abs(evt.getX() / zoom - this.selectedObject.getX()));
        } else if (this.scalingObjectVertical) {
            this.selectedObject.setScaleY(2 * Math.abs(evt.getY() / zoom - this.selectedObject.getY()));
        } else if (this.hoverPoint != null) {
            this.hoverPoint.x = evt.getX() / zoom;
            this.hoverPoint.y = evt.getY() / zoom;
            this.fireCursorToggle(true);
            this.fireQueryRepaint();
        } else if (this.hoverObject != null) {
            this.hoverObject.setX(evt.getX() / zoom);
            this.hoverObject.setY(evt.getY() / zoom);
            this.fireCursorToggle(true);
            this.fireQueryRepaint();
        }
    }

    public void onMouseReleased(MouseEvent evt, int zoom) {
        this.fireCursorToggle(false);
        if (this.selectedEdge != null) {
            this.fireSelectionChanged(this.selectedEdge);
        } else if (this.selectedSegment != null) {
            this.fireSelectionChanged(this.selectedSegment);
        } else if (this.selectedObject != null) {
            this.fireSelectionChanged(this.selectedObject);
        }
    }

    public void onPaint(ViewPort.CustomPaintEvent evt) {
        int zoom = evt.graphics.getZoom();
        Graphics2D g2d = (Graphics2D)evt.graphics.raw;
        if (this.selectedSegment != null && this.selectedEdge == null) {
            this.selectedSegment.paint(evt.graphics, PaintType.SELECTED);
        } else if (this.selectedEdge != null) {
            this.selectedEdge.paint(evt.graphics, PaintType.SELECTED);
        }
        if (this.hoverObject != null) {
            this.hoverObject.hoverPaint(evt.graphics);
        }
        if (this.selectedObject != null) {
            this.selectedObject.selectedPaint(evt.graphics);
        }
        if (this.hoverPoint != null) {
            if (this.ctrlDown) {
                g2d.setColor(Color.red);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(this.hoverPoint.x * zoom - 5, this.hoverPoint.y * zoom - 5, this.hoverPoint.x * zoom + 5, this.hoverPoint.y * zoom + 5);
                g2d.drawLine(this.hoverPoint.x * zoom - 5, this.hoverPoint.y * zoom + 5, this.hoverPoint.x * zoom + 5, this.hoverPoint.y * zoom - 5);
            } else {
                g2d.setColor(Color.red);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawOval(this.hoverPoint.x * zoom - 5, this.hoverPoint.y * zoom - 5, 11, 11);
            }
        }
        if (this.hoverEdge != null) {
            if (this.hoverEdge.getRelatedSegments().isEmpty() || this.selectedSegment != null && this.selectedSegment.edges().contains(this.hoverEdge)) {
                this.hoverEdge.paint(evt.graphics, PaintType.HOVER);
            } else if (this.hoverEdge.getRelatedSegments().size() != 0) {
                this.hoverEdge.getRelatedSegments().firstElement().paint(evt.graphics, PaintType.HOVER);
            }
        }
    }

    public void suggestSelection(Annotable suggestedSelection) {
        if (suggestedSelection instanceof Segment) {
            this.selectedObject = null;
            this.selectedEdge = null;
            this.selectedSegment = (Segment)suggestedSelection;
        } else if (suggestedSelection instanceof Edge) {
            this.selectedObject = null;
            this.selectedEdge = (Edge)suggestedSelection;
            this.selectedSegment = null;
        } else if (suggestedSelection instanceof SceneObject) {
            this.selectedObject = (SceneObject)suggestedSelection;
            this.selectedEdge = null;
            this.selectedSegment = null;
        } else {
            return;
        }
        this.fireSelectionChanged(suggestedSelection);
    }
}

