/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI.tools;

import annotator.GUI.DisplayedRelationsModel;
import annotator.GUI.ViewPort;
import annotator.GUI.tools.KeyStrokeCommand;
import annotator.GUI.tools.Tool;
import annotator.GUI.tools.ToolListener;
import annotator.PaintType;
import annotator.Picture;
import annotator.annotations.Annotable;
import annotator.graph.Relation;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

@KeyStrokeCommand(value="shift E")
public class SelectRelationTool
extends Tool {
    protected DisplayedRelationsModel displayedRelationsModel;
    protected Relation hoverRelation = null;
    protected Relation selectedRelation = null;

    public SelectRelationTool(ToolListener listener, ActionMap actionMap, InputMap inputMap, Picture picture, DisplayedRelationsModel displayedRelationsModel) {
        super(listener, actionMap, inputMap, picture);
        this.displayedRelationsModel = displayedRelationsModel;
        this.registerKeystroke(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SelectRelationTool.this.quitTool();
            }
        });
    }

    public void onMouseMoved(MouseEvent evt, int zoom) {
        for (Relation relation : this.picture.relations()) {
            if (!relation.isDisplayed(this.displayedRelationsModel) || !relation.isPointHover(new Point(evt.getX() / zoom, evt.getY() / zoom), zoom)) continue;
            if (relation != this.hoverRelation) {
                this.hoverRelation = relation;
                this.fireQueryRepaint();
            }
            return;
        }
        if (this.hoverRelation != null) {
            this.hoverRelation = null;
            this.fireQueryRepaint();
        }
    }

    public void onMousePressed(MouseEvent evt, int zoom) {
        if (this.hoverRelation != null && this.hoverRelation != this.selectedRelation) {
            this.selectedRelation = this.hoverRelation;
            this.fireSelectionChanged(this.selectedRelation);
            this.fireQueryRepaint();
        }
    }

    public void onPaint(ViewPort.CustomPaintEvent evt) {
        if (this.hoverRelation != null) {
            this.hoverRelation.paint(evt.graphics, PaintType.HOVER);
        }
        if (this.selectedRelation != null) {
            this.selectedRelation.paint(evt.graphics, PaintType.SELECTED);
        }
    }

    public void suggestSelection(Annotable suggestedSelection) {
        if (suggestedSelection instanceof Relation) {
            this.selectedRelation = (Relation)suggestedSelection;
            this.fireSelectionChanged(this.selectedRelation);
        }
    }
}

