/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI.tools;

import annotator.GUI.ViewPort;
import annotator.GUI.ZoomedGraphics;
import annotator.GUI.tools.KeyStrokeCommand;
import annotator.GUI.tools.Tool;
import annotator.GUI.tools.ToolListener;
import annotator.ObjectCache;
import annotator.PaintType;
import annotator.Picture;
import annotator.graph.Edge;
import annotator.graph.Line;
import annotator.graph.Point;
import annotator.graph.Segment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

@KeyStrokeCommand(value="alt S")
public class SegmentTool
extends Tool {
    protected Point firstPoint = null;
    protected Point lastPoint = null;
    protected Segment segment;
    protected Vector<Edge> edges = new Vector();
    protected Edge currentEdge = null;
    protected Edge firstEdge = null;
    protected boolean ctrlDown;
    protected Point hoverPoint = null;
    protected Point selectedPoint = null;
    protected boolean outlineLastPoint = false;
    protected Vector<Edge> availableEdges = new Vector();
    protected Edge hoverEdge = null;

    public SegmentTool(ToolListener listener, ActionMap actionMap, InputMap inputMap, Picture picture) {
        super(listener, actionMap, inputMap, picture);
        this.segment = new Segment(picture);
        this.firstEdge = this.currentEdge = new Edge(picture);
        this.currentEdge.assignToSegment(this.segment);
        this.edges.add(this.currentEdge);
        this.registerKeystroke(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SegmentTool.this.confirmSegment();
            }
        });
        this.registerKeystroke(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SegmentTool.this.cancelSegment();
                SegmentTool.this.quitTool();
            }
        });
        this.fireCursorToggle(true);
    }

    public void onMousePressed(MouseEvent evt, int zoom) {
        if (this.hoverPoint != null) {
            this.selectedPoint = this.hoverPoint;
            this.availableEdges = new Vector();
            for (Line line : this.selectedPoint.getRelatedLines()) {
                if (this.availableEdges.contains(line.getEdge())) continue;
                this.availableEdges.add(line.getEdge());
            }
            this.outlineLastPoint = false;
        } else if (this.hoverEdge != null) {
            if (this.lastPoint != null) {
                Line newLine = new Line(this.lastPoint, this.selectedPoint);
                newLine.assignToEdge(this.currentEdge);
            }
            this.edges.add(this.hoverEdge);
            this.hoverEdge.assignToSegment(this.segment);
            this.currentEdge = new Edge(this.picture);
            this.edges.add(this.currentEdge);
            this.currentEdge.assignToSegment(this.segment);
            this.lastPoint = this.hoverEdge.findOtherMarginalPoint(this.selectedPoint);
            this.selectedPoint = null;
            this.hoverEdge = null;
            this.outlineLastPoint = true;
            this.fireQueryRepaint();
        } else if (this.selectedPoint == null) {
            Point point = new Point(evt.getPoint());
            point.x /= zoom;
            point.y /= zoom;
            if (this.lastPoint != null) {
                Line newLine = new Line(this.lastPoint, point);
                newLine.assignToEdge(this.currentEdge);
            }
            this.lastPoint = point;
            if (this.firstPoint == null) {
                this.firstPoint = point;
            }
            this.outlineLastPoint = false;
            this.fireQueryRepaint();
        }
    }

    public void onMouseMoved(MouseEvent evt, int zoom) {
        this.ctrlDown = evt.isControlDown();
        Point newHoverPoint = null;
        boolean toBeRepainted = false;
        if (this.ctrlDown && this.selectedPoint == null) {
            for (Point point : ObjectCache.getPointCache()) {
                if (Math.abs(evt.getX() / zoom - point.x) >= 10 || Math.abs(evt.getY() / zoom - point.y) >= 10 || !point.isMarginal()) continue;
                newHoverPoint = point;
            }
        }
        Edge newHoverEdge = null;
        if (this.selectedPoint != null) {
            for (Line line : ObjectCache.getLineCache()) {
                if (!line.isPointHover(new java.awt.Point(evt.getX() / zoom, evt.getY() / zoom), zoom) || !this.availableEdges.contains(line.getEdge())) continue;
                newHoverEdge = line.getEdge();
            }
        }
        if (this.hoverEdge != newHoverEdge) {
            toBeRepainted = true;
        }
        this.hoverEdge = newHoverEdge;
        if (this.hoverPoint != newHoverPoint) {
            toBeRepainted = true;
        }
        this.hoverPoint = newHoverPoint;
        if (toBeRepainted) {
            this.fireQueryRepaint();
        }
    }

    public void onPaint(ViewPort.CustomPaintEvent evt) {
        ZoomedGraphics graphics = evt.graphics;
        int zoom = evt.zoom;
        Graphics2D g2d = (Graphics2D)evt.graphics.raw;
        if (this.lastPoint == null) {
            return;
        }
        if (this.segment.getLines().isEmpty()) {
            this.outlinePoint(graphics, this.lastPoint.x * zoom, this.lastPoint.y * zoom);
        } else {
            boolean firstPoint = true;
            for (Line line : this.segment.getLines()) {
                if (firstPoint) {
                    this.outlinePoint(graphics, line.getPointA().x * zoom, line.getPointA().y * zoom);
                    firstPoint = false;
                }
                graphics.drawLine(line.getPointA().x, line.getPointA().y, line.getPointB().x, line.getPointB().y);
            }
        }
        if (this.outlineLastPoint) {
            g2d.setColor(Color.blue);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawOval(this.lastPoint.x * zoom - 5, this.lastPoint.y * zoom - 5, 11, 11);
        }
        if (this.hoverPoint != null) {
            g2d.setColor(Color.red);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawOval(this.hoverPoint.x * zoom - 5, this.hoverPoint.y * zoom - 5, 11, 11);
        }
        if (this.selectedPoint != null) {
            g2d.setColor(Color.green);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawOval(this.selectedPoint.x * zoom - 5, this.selectedPoint.y * zoom - 5, 11, 11);
            g2d.setColor(Color.black);
            g2d.setStroke(new BasicStroke(1.0f));
            graphics.drawLine(this.lastPoint.x, this.lastPoint.y, this.selectedPoint.x, this.selectedPoint.y);
        }
        if (this.hoverEdge != null) {
            this.hoverEdge.paint(graphics, PaintType.HOVER);
        }
    }

    public void onAbort() {
        this.cancelSegment();
    }

    protected void outlinePoint(ZoomedGraphics graphics, int x, int y) {
        graphics.raw.drawLine(x - 3, y - 3, x + 3, y + 3);
        graphics.raw.drawLine(x - 3, y + 3, x + 3, y - 3);
    }

    private void confirmSegment() {
        if (this.segment.getLines().size() < 2) {
            this.cancelSegment();
            this.quitTool();
            return;
        }
        if (this.currentEdge != this.firstEdge) {
            Vector linesToReassign = (Vector)this.currentEdge.getLines().clone();
            for (Line line : linesToReassign) {
                line.unassignFromEdge(this.currentEdge);
                line.assignToEdge(this.firstEdge);
            }
            this.currentEdge.unassignFromSegment(this.segment);
            this.currentEdge.destroy();
            this.currentEdge = this.firstEdge;
        }
        Line lastLine = new Line(this.lastPoint, this.firstPoint);
        lastLine.assignToEdge(this.currentEdge);
        this.picture.segments().add(this.segment);
        this.segment.initCache();
        this.segment.initName(this.picture.segments());
        this.suggestedSelection = this.segment;
        this.quitTool();
    }

    private void cancelSegment() {
        this.segment.destroy();
    }
}

