/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI.tools;

import annotator.GUI.ViewPort;
import annotator.GUI.tools.KeyStrokeCommand;
import annotator.GUI.tools.Tool;
import annotator.GUI.tools.ToolCancelledException;
import annotator.GUI.tools.ToolListener;
import annotator.ObjectCache;
import annotator.PaintType;
import annotator.Picture;
import annotator.annotations.Annotable;
import annotator.graph.AdjacentRelation;
import annotator.graph.Edge;
import annotator.graph.ImageNextToRelation;
import annotator.graph.InSegmentRelation;
import annotator.graph.Line;
import annotator.graph.Relation;
import annotator.graph.SceneNextToRelation;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

@KeyStrokeCommand(value="alt R")
public class RelationTool
extends Tool {
    protected RelationType relationType;
    protected GraphNodeType sourceNodeType;
    protected GraphNodeType destinationNodeType;
    protected Annotable sourceNode = null;
    protected Annotable destinationNode = null;
    protected Annotable hoverObject = null;

    public RelationTool(ToolListener listener, ActionMap actionMap, InputMap inputMap, Picture picture, RelationType relationType, GraphNodeType sourceNodeType, GraphNodeType destinationNodeType) throws ToolCancelledException {
        super(listener, actionMap, inputMap, picture);
        this.relationType = relationType;
        this.sourceNodeType = sourceNodeType;
        this.destinationNodeType = destinationNodeType;
        this.registerKeystroke(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RelationTool.this.quitTool();
            }
        });
        switch (relationType) {
            case ADJACENT: {
                if (sourceNodeType == GraphNodeType.OBJECT && destinationNodeType == GraphNodeType.OBJECT) break;
                JOptionPane.showMessageDialog(null, "ADJACENT relation is only valid between OBJECTS.");
                this.quitTool();
                throw new ToolCancelledException();
            }
            case SCENENEXTTO: {
                if (sourceNodeType == GraphNodeType.OBJECT && destinationNodeType == GraphNodeType.OBJECT) break;
                JOptionPane.showMessageDialog(null, "NEXT_TO_SCENE relation is only valid between OBJECTS.");
                this.quitTool();
                throw new ToolCancelledException();
            }
            case INSEGMENT: {
                if (sourceNodeType == GraphNodeType.SEGMENT) break;
                JOptionPane.showMessageDialog(null, "IN_SEGMENT relation must start from SEGMENT.");
                this.quitTool();
                throw new ToolCancelledException();
            }
        }
    }

    public void onMouseMoved(MouseEvent evt, int zoom) {
        GraphNodeType nodeType = this.sourceNode == null ? this.sourceNodeType : this.destinationNodeType;
        Point mousePoint = new Point(evt.getX() / zoom, evt.getY() / zoom);
        switch (nodeType) {
            case EDGE: {
                this.getHoverEdge(mousePoint, zoom);
                break;
            }
            case OBJECT: {
                this.getHoverObject(mousePoint);
                break;
            }
            case SEGMENT: {
                this.getHoverEdge(mousePoint, zoom);
                if (this.hoverObject == null) break;
                this.hoverObject = !((Edge)this.hoverObject).getRelatedSegments().isEmpty() ? (Annotable)((Edge)this.hoverObject).getRelatedSegments().firstElement() : null;
            }
        }
        if (this.hoverObject == this.sourceNode) {
            this.hoverObject = null;
        }
    }

    public void onMousePressed(MouseEvent evt, int zoom) {
        if (this.hoverObject != null) {
            if (this.sourceNode == null) {
                this.sourceNode = this.hoverObject;
                this.hoverObject = null;
            } else {
                this.destinationNode = this.hoverObject;
                Relation relation = null;
                switch (this.relationType) {
                    case INSEGMENT: {
                        relation = new InSegmentRelation(this.picture, this.sourceNode, this.destinationNode);
                        break;
                    }
                    case IMAGENEXTTO: {
                        relation = new ImageNextToRelation(this.picture, this.sourceNode, this.destinationNode);
                        break;
                    }
                    case SCENENEXTTO: {
                        relation = new SceneNextToRelation(this.picture, this.sourceNode, this.destinationNode);
                        break;
                    }
                    case ADJACENT: {
                        relation = new AdjacentRelation(this.picture, this.sourceNode, this.destinationNode);
                    }
                }
                this.picture.relations().add(relation);
                this.suggestsRelationSelect = true;
                this.suggestedSelection = relation;
                this.quitTool();
            }
        }
    }

    public void onPaint(ViewPort.CustomPaintEvent evt) {
        if (this.sourceNode instanceof Segment) {
            ((Segment)this.sourceNode).paint(evt.graphics, PaintType.SELECTED);
        } else if (this.sourceNode instanceof Edge) {
            ((Edge)this.sourceNode).paint(evt.graphics, PaintType.SELECTED);
        } else if (this.sourceNode instanceof SceneObject) {
            ((SceneObject)this.sourceNode).selectedPaint(evt.graphics);
        }
        if (this.hoverObject instanceof Segment) {
            ((Segment)this.hoverObject).paint(evt.graphics, PaintType.HOVER);
        } else if (this.hoverObject instanceof Edge) {
            ((Edge)this.hoverObject).paint(evt.graphics, PaintType.HOVER);
        } else if (this.hoverObject instanceof SceneObject) {
            ((SceneObject)this.hoverObject).hoverPaint(evt.graphics);
        }
    }

    private void getHoverEdge(Point point, int zoom) {
        Edge newHoverEdge = null;
        for (Line line : ObjectCache.getLineCache()) {
            if (!line.isPointHover(point, zoom) || line.getEdge() == this.sourceNode) continue;
            newHoverEdge = line.getEdge();
            break;
        }
        if (newHoverEdge != this.hoverObject) {
            this.hoverObject = newHoverEdge;
            this.fireQueryRepaint();
        }
    }

    private void getHoverObject(Point mousePoint) {
        SceneObject newHoverObject = null;
        for (SceneObject object : ObjectCache.getObjectCache()) {
            if (object == this.sourceNode || Math.abs(mousePoint.x - object.getX()) >= 10 || Math.abs(mousePoint.y - object.getY()) >= 10) continue;
            newHoverObject = object;
            break;
        }
        if (newHoverObject != this.hoverObject) {
            this.hoverObject = newHoverObject;
            this.fireQueryRepaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphNodeType {
        EDGE,
        SEGMENT,
        OBJECT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelationType {
        INSEGMENT,
        IMAGENEXTTO,
        SCENENEXTTO,
        ADJACENT;

    }
}

