/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI.tools;

import annotator.GUI.ViewPort;
import annotator.GUI.ZoomedGraphics;
import annotator.GUI.tools.KeyStrokeCommand;
import annotator.GUI.tools.Tool;
import annotator.GUI.tools.ToolListener;
import annotator.Picture;
import annotator.graph.Edge;
import annotator.graph.Line;
import annotator.graph.Point;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

@KeyStrokeCommand(value="alt E")
public class EdgeTool
extends Tool {
    protected Edge edge;
    protected Point lastPoint = null;
    protected Point firstPoint = null;

    public EdgeTool(ToolListener listener, ActionMap actionMap, InputMap inputMap, Picture picture) {
        super(listener, actionMap, inputMap, picture);
        this.edge = new Edge(picture);
        this.registerKeystroke(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EdgeTool.this.confirmEdge();
            }
        });
        this.registerKeystroke(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EdgeTool.this.cancelEdge();
                EdgeTool.this.quitTool();
            }
        });
        this.fireCursorToggle(true);
    }

    public void onMousePressed(MouseEvent evt, int zoom) {
        Point point = new Point(evt.getPoint());
        point.x /= zoom;
        point.y /= zoom;
        if (this.lastPoint != null) {
            Line newLine = new Line(this.lastPoint, point);
            newLine.assignToEdge(this.edge);
        }
        this.lastPoint = point;
        if (this.firstPoint == null) {
            this.firstPoint = point;
        }
        this.fireQueryRepaint();
    }

    public void onPaint(ViewPort.CustomPaintEvent evt) {
        ZoomedGraphics graphics = evt.graphics;
        int zoom = evt.zoom;
        Graphics2D g2d = (Graphics2D)evt.graphics.raw;
        if (this.lastPoint == null) {
            return;
        }
        if (this.edge.getLines().isEmpty()) {
            this.outlinePoint(graphics, this.lastPoint.x * zoom, this.lastPoint.y * zoom);
        } else {
            boolean firstPoint = true;
            for (Line line : this.edge.getLines()) {
                if (firstPoint) {
                    this.outlinePoint(graphics, line.getPointA().x * zoom, line.getPointA().y * zoom);
                    firstPoint = false;
                }
                graphics.drawLine(line.getPointA().x, line.getPointA().y, line.getPointB().x, line.getPointB().y);
            }
        }
    }

    public void onAbort() {
        this.cancelEdge();
    }

    protected void outlinePoint(ZoomedGraphics graphics, int x, int y) {
        graphics.raw.drawLine(x - 3, y - 3, x + 3, y + 3);
        graphics.raw.drawLine(x - 3, y + 3, x + 3, y - 3);
    }

    private void confirmEdge() {
        if (this.edge.getLines().size() < 1) {
            this.quitTool();
            this.cancelEdge();
        }
        this.picture.singleEdges().add(this.edge);
        this.edge.initCache();
        this.edge.initName(this.picture.allEdges());
        this.suggestedSelection = this.edge;
        this.quitTool();
    }

    private void cancelEdge() {
        this.edge.destroy();
    }
}

