/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI;

import annotator.GUI.AnnotatorView;
import annotator.GUI.ZoomedGraphics;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class ViewPort
extends JPanel {
    protected Point cursor;
    protected boolean displayCursor = false;
    protected boolean displayMousePointer = true;
    private Vector listeners = new Vector();
    protected int zoom = 1;
    private boolean cursor_out = true;
    Image backBuffer = null;
    protected Semaphore semaphore = new Semaphore(1);
    protected Image image = null;

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public void hideMousePointer() {
        if (!this.displayMousePointer) {
            return;
        }
        this.setCursor(this.getToolkit().createCustomCursor(new BufferedImage(3, 3, 2), new Point(0, 0), "blank"));
        this.displayMousePointer = false;
    }

    public void showMousePointer() {
        if (this.displayMousePointer) {
            return;
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.displayMousePointer = true;
    }

    protected void paintComponent(Graphics g_front) {
        if (this.semaphore.tryAcquire()) {
            super.paintComponent(g_front);
            if (this.backBuffer == null) {
                this.backBuffer = this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics g = this.backBuffer.getGraphics();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            Rectangle clipBounds = g_front.getClipBounds();
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            Graphics subgraph = g;
            if (this.image != null) {
                if (this.zoom * this.image.getWidth(null) < g.getClipBounds().width && this.zoom * this.image.getHeight(null) < g.getClipBounds().height) {
                    g.drawImage(this.image, g.getClipBounds().width / 2 - this.zoom * this.image.getWidth(null) / 2, g.getClipBounds().height / 2 - this.zoom * this.image.getHeight(null) / 2, this.zoom * this.image.getWidth(null), this.zoom * this.image.getHeight(null), null);
                    subgraph = g.create(g.getClipBounds().width / 2 - this.zoom * this.image.getWidth(null) / 2, g.getClipBounds().height / 2 - this.zoom * this.image.getHeight(null) / 2, this.zoom * this.image.getWidth(null), this.zoom * this.image.getHeight(null));
                } else {
                    int srcx1 = clipBounds.x / this.zoom;
                    int srcy1 = clipBounds.y / this.zoom;
                    int srcx2 = srcx1 + clipBounds.width / this.zoom;
                    int srcy2 = srcy1 + clipBounds.height / this.zoom;
                    int dstx1 = clipBounds.x;
                    int dsty1 = clipBounds.y;
                    int dstx2 = clipBounds.x + clipBounds.width;
                    int dsty2 = clipBounds.y + clipBounds.height;
                    g.drawImage(this.image, dstx1, dsty1, dstx2, dsty2, srcx1, srcy1, srcx2, srcy2, null);
                }
            }
            if (this.displayCursor && !this.cursor_out) {
                g.drawLine(this.cursor.x, 0, this.cursor.x, g.getClipBounds().height + g.getClipBounds().y);
                g.drawLine(0, this.cursor.y, g.getClipBounds().width + g.getClipBounds().x, this.cursor.y);
            }
            this.fireCustomPaint(new ZoomedGraphics(subgraph, this.zoom), this.zoom);
            g_front.drawImage(this.backBuffer, 0, 0, this);
            g.dispose();
            this.semaphore.release();
        } else {
            Logger.getLogger(AnnotatorView.class.getName()).log(Level.SEVERE, ":(:(:(");
        }
    }

    public void updateCursor(Point pt) {
        this.cursor = pt;
        this.cursor_out = false;
        this.repaint();
    }

    public void hideCursor() {
        if (!this.displayCursor) {
            return;
        }
        this.displayCursor = false;
        this.repaint();
    }

    public void showCursor() {
        if (this.displayCursor) {
            return;
        }
        this.displayCursor = true;
        this.repaint();
    }

    public void loadImage(Image image) {
        this.image = image;
    }

    void zoomIn() {
        ++this.zoom;
    }

    void zoomOut() {
        if (this.zoom == 1) {
            return;
        }
        --this.zoom;
    }

    public synchronized void addCustomListener(CustomPaintListener acl) {
        this.listeners.addElement(acl);
    }

    public synchronized void removeCustomListener(CustomPaintListener acl) {
        this.listeners.removeElement(acl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCustomPaint(ZoomedGraphics graphics, int zoom) {
        Vector l;
        CustomPaintEvent e = new CustomPaintEvent(this, graphics, zoom);
        ViewPort viewPort = this;
        synchronized (viewPort) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            ((CustomPaintListener)l.elementAt(i)).customPaint(e);
        }
    }

    int scaleIn(int x) {
        return (int)((double)x / (double)this.zoom * ((double)this.zoom + 1.0));
    }

    int scaleOut(int x) {
        return (int)((double)x / (double)this.zoom * ((double)this.zoom - 1.0));
    }

    void setCursorOut() {
        this.cursor_out = true;
    }

    public void revalidate() {
        super.revalidate();
        this.backBuffer = null;
    }

    public class CustomPaintEvent
    extends AWTEvent {
        public ZoomedGraphics graphics;
        public int zoom;

        public CustomPaintEvent(Component component, ZoomedGraphics graphics, int zoom) {
            super(component, 0);
            this.graphics = graphics;
            this.zoom = zoom;
        }
    }

    protected static interface CustomPaintListener
    extends EventListener {
        public void customPaint(CustomPaintEvent var1);
    }
}

