/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI;

import annotator.AnnotatorApp;
import annotator.Picture;
import annotator.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class PictureRepository
extends JFrame {
    protected Project project;
    protected ArrayList<Picture> pictures;
    protected RepositoryListModel picturesModel = new RepositoryListModel();
    private JButton btnAdd;
    private JButton btnCancel;
    private JButton btnOK;
    private JButton btnRemove;
    private JScrollPane jScrollPane1;
    private JList lstPictures;

    protected void afterSubmit() {
    }

    public PictureRepository(Project project) {
        this.project = project;
        this.pictures = (ArrayList)project.Pictures().clone();
        this.initComponents();
    }

    protected FilenameFilter getFilenameFilter() {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String name_l = name.toLowerCase();
                return name_l.endsWith(".png") || name_l.endsWith(".jpg") || name_l.endsWith(".gif") || name_l.endsWith(".jpeg") || name_l.endsWith(".bmp");
            }
        };
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstPictures = new JList();
        this.btnAdd = new JButton();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.btnRemove = new JButton();
        ResourceMap resourceMap = Application.getInstance(AnnotatorApp.class).getContext().getResourceMap(PictureRepository.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.setResizable(false);
        this.jScrollPane1.setName("jScrollPane1");
        this.lstPictures.setModel(this.picturesModel);
        this.lstPictures.setName("lstPictures");
        this.jScrollPane1.setViewportView(this.lstPictures);
        this.btnAdd.setText(resourceMap.getString("btnAdd.text", new Object[0]));
        this.btnAdd.setName("btnAdd");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PictureRepository.this.btnAddActionPerformed(evt);
            }
        });
        this.btnOK.setText(resourceMap.getString("btnOK.text", new Object[0]));
        this.btnOK.setName("btnOK");
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PictureRepository.this.btnOKActionPerformed(evt);
            }
        });
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PictureRepository.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnRemove.setText(resourceMap.getString("btnRemove.text", new Object[0]));
        this.btnRemove.setName("btnRemove");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PictureRepository.this.btnRemoveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 356, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 298, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOK).addComponent(this.btnAdd).addComponent(this.btnRemove)).addContainerGap()));
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File[] files;
            for (File file : files = fc.getSelectedFiles()) {
                if (file.isDirectory()) {
                    this.addDirectoryContents(file);
                    continue;
                }
                this.picturesModel.add(new Picture(file, ""));
            }
        }
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.project.SetPictures(this.pictures);
        this.setVisible(false);
        this.afterSubmit();
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int[] selectedIndices = this.lstPictures.getSelectedIndices();
        if (selectedIndices.length > 0 && JOptionPane.showConfirmDialog(this, "Remove selected pictures from project?", "Pictures removal", 0) == 0) {
            Vector<Picture> picturesToRemove = new Vector<Picture>();
            for (int i : selectedIndices) {
                picturesToRemove.add(this.picturesModel.getPictureAt(i));
            }
            this.picturesModel.removeAll(picturesToRemove);
        }
    }

    private void refreshList() {
    }

    private void addDirectoryContents(File file) {
        for (File dir : file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            this.addDirectoryContents(dir);
        }
        for (File file_in_dir : file.listFiles(this.getFilenameFilter())) {
            this.picturesModel.add(new Picture(file_in_dir, this.project.getPath()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepositoryListModel
    extends AbstractListModel {
        protected RepositoryListModel() {
        }

        @Override
        public int getSize() {
            return PictureRepository.this.pictures.size();
        }

        @Override
        public Object getElementAt(int i) {
            return PictureRepository.this.pictures.get(i).getFilename();
        }

        public Picture getPictureAt(int i) {
            return PictureRepository.this.pictures.get(i);
        }

        public void add(Picture picture) {
            int oldLastIndex = PictureRepository.this.pictures.size() - 1;
            PictureRepository.this.pictures.add(picture);
            this.fireIntervalAdded(this, oldLastIndex + 1, oldLastIndex + 1);
            this.fireContentsChanged(this, oldLastIndex + 1, oldLastIndex + 1);
        }

        public void remove(int i) {
            PictureRepository.this.pictures.remove(i);
            this.fireIntervalRemoved(this, i, i);
        }

        public void removeAll(Collection<Picture> coll) {
            int i = PictureRepository.this.pictures.indexOf(coll.iterator().next());
            PictureRepository.this.pictures.removeAll(coll);
            this.fireIntervalRemoved(this, i, i);
        }
    }
}

