/*
 * Decompiled with CFR 0.152.
 */
package annotator.GUI;

import annotator.AnnotatorAboutBox;
import annotator.AnnotatorApp;
import annotator.GUI.DisplayedRelationsModel;
import annotator.GUI.EmptyTableModel;
import annotator.GUI.JPropertiesTable;
import annotator.GUI.JRecentProjectMenuItem;
import annotator.GUI.PictureRepository;
import annotator.GUI.ViewPort;
import annotator.GUI.tools.EdgeTool;
import annotator.GUI.tools.KeyStrokeCommand;
import annotator.GUI.tools.ObjectTool;
import annotator.GUI.tools.RelationTool;
import annotator.GUI.tools.SegmentTool;
import annotator.GUI.tools.SelectRelationTool;
import annotator.GUI.tools.SelectTool;
import annotator.GUI.tools.SplitEdgeTool;
import annotator.GUI.tools.Tool;
import annotator.GUI.tools.ToolCancelledException;
import annotator.GUI.tools.ToolListener;
import annotator.NameChangeNotifier;
import annotator.NameChangeObserver;
import annotator.ObjectCache;
import annotator.PaintType;
import annotator.Picture;
import annotator.Project;
import annotator.annotations.Annotable;
import annotator.annotations.AnnotationsTableModel;
import annotator.graph.Edge;
import annotator.graph.GraphNode;
import annotator.graph.Relation;
import annotator.graph.SceneObject;
import annotator.graph.Segment;
import annotator.tasks.Task;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class AnnotatorView
extends FrameView
implements ToolListener,
NameChangeObserver {
    Semaphore semaphore = new Semaphore(1);
    Project project;
    protected ListIterator<Picture> currentPictureIterator;
    protected Picture currentPicture = null;
    Tool currentTool = null;
    protected BufferedImage image;
    protected Preferences prefs;
    protected final int RECENT_PROJECTS = 4;
    protected final String PREF_RECENT_PROJECT_NAME = "recent_project_name_";
    protected final String PREF_RECENT_PROJECT_PATH = "recent_project_path_";
    protected Set<JMenuItem> recentProjectsMenus = new HashSet<JMenuItem>();
    protected FileNameExtensionFilter projectFileFilter = new FileNameExtensionFilter("Annotator project", "anp");
    protected Object selection = null;
    protected DisplayedRelationsModel displayedRelationsModel;
    protected final Class[] toolClasses = new Class[]{SelectTool.class, SegmentTool.class, EdgeTool.class, ObjectTool.class, SplitEdgeTool.class, RelationTool.class, SelectRelationTool.class};
    protected Map<Class, AbstractButton> toolClassesActions = new HashMap<Class, AbstractButton>();
    protected LinkedHashMap<String, String> recentProjects = new LinkedHashMap<String, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 4;
        }
    };
    private JToggleButton btnAddEdge;
    private JToggleButton btnAddObject;
    private JToggleButton btnAddRelation;
    private JToggleButton btnAddSegment;
    private JButton btnDelete;
    private JButton btnHideAll;
    private JButton btnNext;
    private JButton btnPrevious;
    private JToggleButton btnSelect;
    private JToggleButton btnSelectRelation;
    private JButton btnShowAll;
    private JToggleButton btnSplitEdge;
    private JComboBox cbRelationDestination;
    private JComboBox cbRelationSource;
    private JComboBox cbRelationType;
    private JCheckBox chkAdjacent;
    private JCheckBox chkImageNextTo;
    private JCheckBox chkInSegment;
    private JCheckBox chkSceneNextTo;
    private JMenu fileMenu;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JToolBar jToolBar1;
    private JLabel lblSelection;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JPopupMenu.Separator mnuFileSeparator1;
    private JPopupMenu.Separator mnuFileSeparator2;
    private JMenuItem mnuNewProject;
    private JMenuItem mnuOpenProject;
    private JMenuItem mnuRepository;
    private JMenuItem mnuSaveProject;
    private JMenuItem mnuSaveProjectAs;
    private JProgressBar progressBar;
    private JScrollPane scrollPane;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JPropertiesTable tblProperties;
    private ViewPort viewPort;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public AnnotatorView(SingleFrameApplication app) {
        super(app);
        NameChangeNotifier.getInstance().addObserver(this);
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.loadRecentProjects();
        this.initComponents();
        this.updateRecentProjectsMenu();
        this.initTasks();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotatorView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotatorView.this.busyIconIndex = (AnnotatorView.this.busyIconIndex + 1) % AnnotatorView.this.busyIcons.length;
                AnnotatorView.this.statusAnimationLabel.setIcon(AnnotatorView.this.busyIcons[AnnotatorView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        this.btnDelete.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!AnnotatorView.this.busyIconTimer.isRunning()) {
                        AnnotatorView.this.statusAnimationLabel.setIcon(AnnotatorView.this.busyIcons[0]);
                        AnnotatorView.this.busyIconIndex = 0;
                        AnnotatorView.this.busyIconTimer.start();
                    }
                    AnnotatorView.this.progressBar.setVisible(true);
                    AnnotatorView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    AnnotatorView.this.busyIconTimer.stop();
                    AnnotatorView.this.statusAnimationLabel.setIcon(AnnotatorView.this.idleIcon);
                    AnnotatorView.this.progressBar.setVisible(false);
                    AnnotatorView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    AnnotatorView.this.statusMessageLabel.setText(text == null ? "" : text);
                    AnnotatorView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    AnnotatorView.this.progressBar.setVisible(true);
                    AnnotatorView.this.progressBar.setIndeterminate(false);
                    AnnotatorView.this.progressBar.setValue(value);
                }
            }
        });
        this.displayedRelationsModel = new DisplayedRelationsModel();
        this.viewPort.addCustomListener(new ViewPort.CustomPaintListener(){

            public void customPaint(ViewPort.CustomPaintEvent e) {
                AnnotatorView.this.viewPortCustomPaint(e);
            }
        });
        this.project = new Project();
        this.currentPictureIterator = this.project.Pictures().listIterator();
        if (this.currentPictureIterator.hasNext()) {
            this.currentPicture = this.currentPictureIterator.next();
        }
        this.getFrame().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                AnnotatorView.this.updateViewportSize();
            }
        });
        this.getFrame().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                AnnotatorView.this.updateViewportSize();
            }
        });
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AnnotatorView.this.viewPort.repaint();
                }
            }
        };
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
        this.currentTool = new SelectTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture);
        this.tblProperties.setTableHeader(null);
        this.tblProperties.setInputMap(1, null);
        this.tblProperties.setInputMap(2, null);
        this.getFrame().setMinimumSize(new Dimension(901, 471));
        this.registerKeystrokes();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = AnnotatorApp.getApplication().getMainFrame();
            this.aboutBox = new AnnotatorAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        AnnotatorApp.getApplication().show(this.aboutBox);
    }

    public void updateViewportSize() {
        Dimension newSize = (Dimension)this.scrollPane.getViewport().getSize().clone();
        int zoom = this.viewPort.getZoom();
        if (this.image != null) {
            if (this.image.getWidth() * zoom > newSize.width) {
                newSize.width = this.image.getWidth() * zoom;
            }
            if (this.image.getHeight() * zoom > newSize.height) {
                newSize.height = this.image.getHeight() * zoom;
            }
        }
        this.viewPort.setPreferredSize(newSize);
        this.viewPort.revalidate();
    }

    private void displayPicture() {
        if (this.currentPicture == null) {
            ObjectCache.clear();
            if (this.currentTool != null) {
                this.currentTool.abortTool();
            }
            this.viewPort.loadImage(null);
            this.viewPort.repaint();
            return;
        }
        try {
            this.image = ImageIO.read(new File(this.currentPicture.getFullPath()));
            this.viewPort.loadImage(this.image);
            ObjectCache.clear();
            this.currentPicture.initCache();
            if (this.currentTool != null) {
                this.currentTool.abortTool();
            }
            this.viewPort.setZoom(1);
            this.updateViewportSize();
            this.viewPort.repaint();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getFrame(), "Could not open image file: " + this.currentPicture.getFullPath());
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblProperties = new JPropertiesTable();
        this.jToolBar1 = new JToolBar();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnSelect = new JToggleButton();
        this.btnAddSegment = new JToggleButton();
        this.btnAddEdge = new JToggleButton();
        this.btnAddObject = new JToggleButton();
        this.btnSplitEdge = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnSelectRelation = new JToggleButton();
        this.btnAddRelation = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.cbRelationSource = new JComboBox();
        this.cbRelationType = new JComboBox();
        this.jLabel1 = new JLabel();
        this.cbRelationDestination = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.viewPort = new ViewPort();
        this.lblSelection = new JLabel();
        this.jPanel1 = new JPanel();
        this.chkImageNextTo = new JCheckBox();
        this.chkAdjacent = new JCheckBox();
        this.chkInSegment = new JCheckBox();
        this.chkSceneNextTo = new JCheckBox();
        this.btnShowAll = new JButton();
        this.btnHideAll = new JButton();
        this.btnDelete = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.mnuNewProject = new JMenuItem();
        this.mnuOpenProject = new JMenuItem();
        this.mnuSaveProject = new JMenuItem();
        this.mnuSaveProjectAs = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.mnuRepository = new JMenuItem();
        this.mnuFileSeparator1 = new JPopupMenu.Separator();
        this.mnuFileSeparator2 = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setMinimumSize(new Dimension(901, 471));
        this.mainPanel.setName("mainPanel");
        this.mainPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                AnnotatorView.this.mainPanelKeyPressed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.tblProperties.setModel(new EmptyTableModel());
        this.tblProperties.setName("tblProperties");
        this.jScrollPane1.setViewportView(this.tblProperties);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        ResourceMap resourceMap = Application.getInstance(AnnotatorApp.class).getContext().getResourceMap(AnnotatorView.class);
        this.btnPrevious.setText(resourceMap.getString("btnPrevious.text", new Object[0]));
        this.btnPrevious.setFocusable(false);
        this.btnPrevious.setHorizontalTextPosition(0);
        this.btnPrevious.setName("btnPrevious");
        this.btnPrevious.setVerticalTextPosition(3);
        this.btnPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnPrevious);
        this.btnNext.setText(resourceMap.getString("btnNext.text", new Object[0]));
        this.btnNext.setFocusable(false);
        this.btnNext.setHorizontalTextPosition(0);
        this.btnNext.setName("btnNext");
        this.btnNext.setVerticalTextPosition(3);
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnNext);
        this.jSeparator1.setName("jSeparator1");
        this.jToolBar1.add(this.jSeparator1);
        this.btnSelect.setSelected(true);
        this.btnSelect.setText(resourceMap.getString("btnSelect.text", new Object[0]));
        this.btnSelect.setFocusable(false);
        this.btnSelect.setHorizontalTextPosition(0);
        this.btnSelect.setName("btnSelect");
        this.btnSelect.setVerticalTextPosition(3);
        this.btnSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnSelectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSelect);
        this.btnAddSegment.setText(resourceMap.getString("btnAddSegment.text", new Object[0]));
        this.btnAddSegment.setFocusable(false);
        this.btnAddSegment.setHorizontalTextPosition(0);
        this.btnAddSegment.setName("btnAddSegment");
        this.btnAddSegment.setVerticalTextPosition(3);
        this.btnAddSegment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnAddSegmentActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAddSegment);
        this.btnAddEdge.setText(resourceMap.getString("btnAddEdge.text", new Object[0]));
        this.btnAddEdge.setFocusable(false);
        this.btnAddEdge.setHorizontalTextPosition(0);
        this.btnAddEdge.setName("btnAddEdge");
        this.btnAddEdge.setVerticalTextPosition(3);
        this.btnAddEdge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnAddEdgeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAddEdge);
        this.btnAddObject.setText(resourceMap.getString("btnAddObject.text", new Object[0]));
        this.btnAddObject.setFocusable(false);
        this.btnAddObject.setHorizontalTextPosition(0);
        this.btnAddObject.setName("btnAddObject");
        this.btnAddObject.setVerticalTextPosition(3);
        this.btnAddObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnAddObjectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAddObject);
        this.btnSplitEdge.setText(resourceMap.getString("btnSplitEdge.text", new Object[0]));
        this.btnSplitEdge.setFocusable(false);
        this.btnSplitEdge.setHorizontalTextPosition(0);
        this.btnSplitEdge.setName("btnSplitEdge");
        this.btnSplitEdge.setVerticalTextPosition(3);
        this.btnSplitEdge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnSplitEdgeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSplitEdge);
        this.jSeparator2.setName("jSeparator2");
        this.jToolBar1.add(this.jSeparator2);
        this.btnSelectRelation.setText(resourceMap.getString("btnSelectRelation.text", new Object[0]));
        this.btnSelectRelation.setFocusable(false);
        this.btnSelectRelation.setHorizontalTextPosition(0);
        this.btnSelectRelation.setName("btnSelectRelation");
        this.btnSelectRelation.setVerticalTextPosition(3);
        this.btnSelectRelation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnSelectRelationActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSelectRelation);
        this.btnAddRelation.setText(resourceMap.getString("btnAddRelation.text", new Object[0]));
        this.btnAddRelation.setFocusable(false);
        this.btnAddRelation.setHorizontalTextPosition(0);
        this.btnAddRelation.setName("btnAddRelation");
        this.btnAddRelation.setVerticalTextPosition(3);
        this.btnAddRelation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnAddRelationActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAddRelation);
        this.jPanel2.setName("jPanel2");
        this.cbRelationSource.setModel(new DefaultComboBoxModel<String>(new String[]{"EDGE", "SEGMENT", "OBJECT"}));
        this.cbRelationSource.setName("cbRelationSource");
        this.cbRelationType.setModel(new DefaultComboBoxModel<String>(new String[]{"IN_SEGMENT", "NEXT_TO_IMAGE", "NEXT_TO_SCENE", "ADJACENT"}));
        this.cbRelationType.setName("cbRelationType");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.cbRelationDestination.setModel(new DefaultComboBoxModel<String>(new String[]{"EDGE", "SEGMENT", "OBJECT"}));
        this.cbRelationDestination.setName("cbRelationDestination");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.cbRelationType, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbRelationSource, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRelationDestination, -2, 106, -2).addContainerGap(61, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRelationType, -2, -1, -2).addComponent(this.cbRelationSource, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.cbRelationDestination, -2, -1, -2)));
        this.jToolBar1.add(this.jPanel2);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setName("scrollPane");
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                AnnotatorView.this.scrollPaneComponentShown(evt);
            }
        });
        this.viewPort.setName("viewPort");
        this.viewPort.setPreferredSize(new Dimension(62, 41));
        this.viewPort.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                AnnotatorView.this.viewPortMouseWheelMoved(evt);
            }
        });
        this.viewPort.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AnnotatorView.this.viewPortMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                AnnotatorView.this.viewPortMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                AnnotatorView.this.viewPortMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AnnotatorView.this.viewPortMouseReleased(evt);
            }
        });
        this.viewPort.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                AnnotatorView.this.viewPortMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                AnnotatorView.this.viewPortMouseMoved(evt);
            }
        });
        this.viewPort.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                AnnotatorView.this.viewPortKeyPressed(evt);
            }
        });
        GroupLayout viewPortLayout = new GroupLayout(this.viewPort);
        this.viewPort.setLayout(viewPortLayout);
        viewPortLayout.setHorizontalGroup(viewPortLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 655, Short.MAX_VALUE));
        viewPortLayout.setVerticalGroup(viewPortLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 412, Short.MAX_VALUE));
        this.scrollPane.setViewportView(this.viewPort);
        this.lblSelection.setFont(resourceMap.getFont("lblSelection.font"));
        this.lblSelection.setText(resourceMap.getString("lblSelection.text", new Object[0]));
        this.lblSelection.setName("lblSelection");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resourceMap.getString("jPanel1.border.title", new Object[0]), 0, 0, new Font("Tahoma", 0, 11), resourceMap.getColor("jPanel1.border.titleColor")));
        this.jPanel1.setName("jPanel1");
        this.chkImageNextTo.setText(resourceMap.getString("chkImageNextTo.text", new Object[0]));
        this.chkImageNextTo.setName("chkImageNextTo");
        this.chkImageNextTo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AnnotatorView.this.chkImageNextToStateChanged(evt);
            }
        });
        this.chkAdjacent.setText(resourceMap.getString("chkAdjacent.text", new Object[0]));
        this.chkAdjacent.setName("chkAdjacent");
        this.chkAdjacent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AnnotatorView.this.chkAdjacentStateChanged(evt);
            }
        });
        this.chkInSegment.setText(resourceMap.getString("chkInSegment.text", new Object[0]));
        this.chkInSegment.setName("chkInSegment");
        this.chkInSegment.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AnnotatorView.this.chkInSegmentStateChanged(evt);
            }
        });
        this.chkSceneNextTo.setText(resourceMap.getString("chkSceneNextTo.text", new Object[0]));
        this.chkSceneNextTo.setName("chkSceneNextTo");
        this.chkSceneNextTo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AnnotatorView.this.chkSceneNextToStateChanged(evt);
            }
        });
        this.btnShowAll.setText(resourceMap.getString("btnShowAll.text", new Object[0]));
        this.btnShowAll.setName("btnShowAll");
        this.btnShowAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnShowAllActionPerformed(evt);
            }
        });
        this.btnHideAll.setText(resourceMap.getString("btnHideAll.text", new Object[0]));
        this.btnHideAll.setName("btnHideAll");
        this.btnHideAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnHideAllActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkAdjacent).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkInSegment).addComponent(this.chkImageNextTo).addComponent(this.chkSceneNextTo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnHideAll, -1, -1, Short.MAX_VALUE).addComponent(this.btnShowAll, -1, 101, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.chkInSegment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkImageNextTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkSceneNextTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkAdjacent)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.btnShowAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnHideAll))).addContainerGap(9, Short.MAX_VALUE)));
        this.btnDelete.setText(resourceMap.getString("btnDelete.text", new Object[0]));
        this.btnDelete.setName("btnDelete");
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.btnDeleteActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblSelection, -1, -1, Short.MAX_VALUE)).addGroup(mainPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.btnDelete, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 672, Short.MAX_VALUE).addContainerGap()).addComponent(this.jToolBar1, -1, 960, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.lblSelection, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 228, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)).addComponent(this.scrollPane, -1, 429, Short.MAX_VALUE)).addContainerGap()));
        this.menuBar.setName("menuBar");
        this.fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        this.fileMenu.setName("fileMenu");
        this.mnuNewProject.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.mnuNewProject.setMnemonic('N');
        this.mnuNewProject.setText(resourceMap.getString("mnuNewProject.text", new Object[0]));
        this.mnuNewProject.setName("mnuNewProject");
        this.mnuNewProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.mnuNewProjectActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.mnuNewProject);
        this.mnuOpenProject.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mnuOpenProject.setText(resourceMap.getString("mnuOpenProject.text", new Object[0]));
        this.mnuOpenProject.setName("mnuOpenProject");
        this.mnuOpenProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.mnuOpenProjectActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.mnuOpenProject);
        this.mnuSaveProject.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mnuSaveProject.setText(resourceMap.getString("mnuSaveProject.text", new Object[0]));
        this.mnuSaveProject.setName("mnuSaveProject");
        this.mnuSaveProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.mnuSaveProjectActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.mnuSaveProject);
        this.mnuSaveProjectAs.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        this.mnuSaveProjectAs.setText(resourceMap.getString("mnuSaveProjectAs.text", new Object[0]));
        this.mnuSaveProjectAs.setName("mnuSaveProjectAs");
        this.mnuSaveProjectAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.mnuSaveProjectAsActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.mnuSaveProjectAs);
        this.jSeparator3.setName("jSeparator3");
        this.fileMenu.add(this.jSeparator3);
        this.mnuRepository.setText(resourceMap.getString("mnuRepository.text", new Object[0]));
        this.mnuRepository.setName("mnuRepository");
        this.mnuRepository.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotatorView.this.mnuRepositoryActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.mnuRepository);
        this.mnuFileSeparator1.setName("mnuFileSeparator1");
        this.fileMenu.add(this.mnuFileSeparator1);
        this.mnuFileSeparator2.setName("mnuFileSeparator2");
        this.fileMenu.add(this.mnuFileSeparator2);
        ApplicationActionMap actionMap = Application.getInstance(AnnotatorApp.class).getContext().getActionMap(AnnotatorView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        this.fileMenu.add(exitMenuItem);
        this.menuBar.add(this.fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 960, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 790, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void viewPortMouseExited(MouseEvent evt) {
        this.viewPort.setCursorOut();
        this.viewPort.repaint();
    }

    private void viewPortMouseMoved(MouseEvent evt) {
        this.viewPort.updateCursor(evt.getPoint());
        if (this.currentTool != null) {
            this.translateMouseEvent(evt);
            this.currentTool.onMouseMoved(evt, this.viewPort.getZoom());
        }
    }

    private void viewPortMouseDragged(MouseEvent evt) {
        this.viewPort.updateCursor(evt.getPoint());
        if (this.currentTool != null) {
            this.translateMouseEvent(evt);
            this.currentTool.onMouseDragged(evt, this.viewPort.getZoom());
        }
    }

    private void viewPortCustomPaint(ViewPort.CustomPaintEvent e) {
        if (this.currentPicture != null) {
            for (Segment segment : this.currentPicture.segments()) {
                segment.paint(e.graphics, PaintType.STANDARD);
            }
            for (SceneObject object : this.currentPicture.objects()) {
                object.paint(e.graphics);
            }
            for (Edge edge : this.currentPicture.singleEdges()) {
                edge.paint(e.graphics, PaintType.STANDARD);
            }
            for (Relation relation : this.currentPicture.relations()) {
                if (!relation.isDisplayed(this.displayedRelationsModel)) continue;
                relation.paint(e.graphics, PaintType.STANDARD);
            }
        }
        if (this.currentTool != null) {
            this.currentTool.onPaint(e);
        }
    }

    private void mnuRepositoryActionPerformed(ActionEvent evt) {
        PictureRepository repository = new PictureRepository(this.project){

            protected void afterSubmit() {
                int previousCurrentPictureIndex = this.project.Pictures().indexOf(AnnotatorView.this.currentPicture);
                if (AnnotatorView.this.currentPicture == null || previousCurrentPictureIndex == -1) {
                    AnnotatorView.this.currentPictureIterator = this.project.Pictures().listIterator();
                    if (AnnotatorView.this.currentPictureIterator.hasNext()) {
                        AnnotatorView.this.currentPicture = AnnotatorView.this.currentPictureIterator.next();
                    }
                } else {
                    AnnotatorView.this.currentPictureIterator = this.project.Pictures().listIterator(previousCurrentPictureIndex);
                    AnnotatorView.this.currentPicture = AnnotatorView.this.currentPictureIterator.next();
                }
                AnnotatorView.this.displayPicture();
            }
        };
        JFrame mainFrame = AnnotatorApp.getApplication().getMainFrame();
        AnnotatorApp.getApplication().show(repository);
        repository.setLocationRelativeTo(mainFrame);
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        boolean edge = false;
        if (this.project.Pictures().isEmpty()) {
            this.currentPicture = null;
        } else {
            if (this.currentPictureIterator.hasNext()) {
                Picture newCurrentPicture = this.currentPictureIterator.next();
                if (newCurrentPicture == this.currentPicture) {
                    if (this.currentPictureIterator.hasNext()) {
                        this.currentPicture = this.currentPictureIterator.next();
                    } else {
                        edge = true;
                    }
                } else {
                    this.currentPicture = newCurrentPicture;
                }
            } else {
                edge = true;
            }
            if (edge) {
                this.currentPictureIterator = this.project.Pictures().listIterator();
                if (this.currentPictureIterator.hasNext()) {
                    this.currentPicture = this.currentPictureIterator.next();
                }
            }
        }
        this.displayPicture();
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        boolean edge = false;
        if (this.project.Pictures().isEmpty()) {
            this.currentPicture = null;
        } else {
            if (this.currentPictureIterator.hasPrevious()) {
                Picture newCurrentPicture = this.currentPictureIterator.previous();
                if (newCurrentPicture == this.currentPicture) {
                    if (this.currentPictureIterator.hasPrevious()) {
                        this.currentPicture = this.currentPictureIterator.previous();
                    } else {
                        edge = true;
                    }
                } else {
                    this.currentPicture = newCurrentPicture;
                }
            } else {
                edge = true;
            }
            if (edge) {
                this.currentPictureIterator = this.project.Pictures().listIterator(this.project.Pictures().size());
                if (this.currentPictureIterator.hasPrevious()) {
                    this.currentPicture = this.currentPictureIterator.previous();
                }
            }
        }
        this.displayPicture();
    }

    private void viewPortMouseClicked(MouseEvent evt) {
    }

    private void scrollPaneComponentShown(ComponentEvent evt) {
    }

    private void viewPortMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            this.translateMouseEvent(evt);
            int xpos = this.viewPort.scaleIn(evt.getX());
            int ypos = this.viewPort.scaleIn(evt.getY());
            this.viewPort.zoomIn();
            this.updateViewportSize();
            this.adaptScrollbars(xpos, ypos);
        } else {
            if (this.viewPort.getZoom() == 1) {
                return;
            }
            this.translateMouseEvent(evt);
            int xpos = this.viewPort.scaleOut(evt.getX());
            int ypos = this.viewPort.scaleOut(evt.getY());
            this.viewPort.zoomOut();
            this.updateViewportSize();
            this.adaptScrollbars(xpos, ypos);
        }
        this.viewPort.repaint();
    }

    private void mnuSaveProjectActionPerformed(ActionEvent evt) {
        if (this.project.getFilename() == null) {
            this.mnuSaveProjectAsActionPerformed(evt);
        } else {
            this.project.save();
        }
    }

    private void mnuOpenProjectActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setFileFilter(this.projectFileFilter);
        int result = fc.showOpenDialog(this.getFrame());
        if (result == 0) {
            String projectFileName = fc.getSelectedFile().getName();
            String projectPath = fc.getSelectedFile().getAbsolutePath();
            Project project = Project.load(projectPath);
            if (project == null) {
                JOptionPane.showMessageDialog(this.getFrame(), "Could not open project.", "Error", 0);
            } else {
                this.setCurrentProject(project);
            }
        }
    }

    private void mnuOpenRecentProjectActionPerformed(ActionEvent e) {
        JRecentProjectMenuItem source = (JRecentProjectMenuItem)e.getSource();
        Project project = Project.load(source.getProjectFileName());
        if (project == null) {
            JOptionPane.showMessageDialog(this.getFrame(), "Could not open project.", "Error", 0);
        } else {
            this.setCurrentProject(project);
        }
    }

    private void btnAddSegmentActionPerformed(ActionEvent evt) {
        this.currentTool.abortTool();
        this.clearToolButtons();
        this.currentTool = new SegmentTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture);
        this.btnAddSegment.setSelected(true);
    }

    private void viewPortKeyPressed(KeyEvent evt) {
    }

    private void viewPortMousePressed(MouseEvent evt) {
        if (this.currentTool != null) {
            this.translateMouseEvent(evt);
            this.currentTool.onMousePressed(evt, this.viewPort.getZoom());
        }
    }

    private void mainPanelKeyPressed(KeyEvent evt) {
        if (this.currentTool != null) {
            this.currentTool.onKeyPressed(evt);
        }
    }

    private void mnuSaveProjectAsActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setFileFilter(this.projectFileFilter);
        fc.setSelectedFile(new File("project.anp"));
        int result = fc.showSaveDialog(this.getFrame());
        if (result == 0) {
            String projectPath = fc.getSelectedFile().getAbsolutePath();
            String projectFileName = fc.getSelectedFile().getName();
            this.project.save(projectPath);
            this.addRecentProject(projectPath, projectFileName);
        }
    }

    private void mnuNewProjectActionPerformed(ActionEvent evt) {
        this.setCurrentProject(new Project());
    }

    private void btnSelectActionPerformed(ActionEvent evt) {
        this.currentTool.abortTool();
    }

    private void viewPortMouseReleased(MouseEvent evt) {
        if (this.currentTool != null) {
            this.translateMouseEvent(evt);
            this.currentTool.onMouseReleased(evt, this.viewPort.getZoom());
        }
    }

    private void btnAddObjectActionPerformed(ActionEvent evt) {
        this.currentTool.abortTool();
        this.clearToolButtons();
        this.currentTool = new ObjectTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture);
        this.btnAddObject.setSelected(true);
    }

    private void btnSplitEdgeActionPerformed(ActionEvent evt) {
        this.currentTool.abortTool();
        this.clearToolButtons();
        this.currentTool = new SplitEdgeTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture);
        this.btnSplitEdge.setSelected(true);
    }

    private void btnAddEdgeActionPerformed(ActionEvent evt) {
        this.currentTool.abortTool();
        this.clearToolButtons();
        this.currentTool = new EdgeTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture);
        this.btnAddEdge.setSelected(true);
    }

    private void btnShowAllActionPerformed(ActionEvent evt) {
        this.chkAdjacent.setSelected(true);
        this.chkImageNextTo.setSelected(true);
        this.chkInSegment.setSelected(true);
        this.chkSceneNextTo.setSelected(true);
        this.updateDisplayedRelations();
    }

    private void btnHideAllActionPerformed(ActionEvent evt) {
        this.chkAdjacent.setSelected(false);
        this.chkInSegment.setSelected(false);
        this.chkImageNextTo.setSelected(false);
        this.chkSceneNextTo.setSelected(false);
        this.updateDisplayedRelations();
    }

    private void chkImageNextToStateChanged(ChangeEvent evt) {
        this.updateDisplayedRelations();
    }

    private void chkInSegmentStateChanged(ChangeEvent evt) {
        this.updateDisplayedRelations();
    }

    private void chkSceneNextToStateChanged(ChangeEvent evt) {
        this.updateDisplayedRelations();
    }

    private void chkAdjacentStateChanged(ChangeEvent evt) {
        this.updateDisplayedRelations();
    }

    private void btnSelectRelationActionPerformed(ActionEvent evt) {
        this.currentTool.abortTool();
        this.clearToolButtons();
        this.currentTool = new SelectRelationTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture, this.displayedRelationsModel);
        this.btnSelectRelation.setSelected(true);
    }

    private void btnAddRelationActionPerformed(ActionEvent evt) {
        this.currentTool.abortTool();
        this.clearToolButtons();
        this.btnAddRelation.setSelected(true);
        RelationTool.GraphNodeType sourceNodeType = this.getNodeType(this.cbRelationSource);
        RelationTool.GraphNodeType destinationNodeType = this.getNodeType(this.cbRelationDestination);
        RelationTool.RelationType relationType = this.getRelationType(this.cbRelationType);
        this.setComboBoxesEnabled(false);
        try {
            this.currentTool = new RelationTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture, relationType, sourceNodeType, destinationNodeType);
        }
        catch (ToolCancelledException ex) {
            // empty catch block
        }
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        int result;
        if (this.selection != null && this.selection instanceof GraphNode && (result = JOptionPane.showConfirmDialog(this.getFrame(), "Are you sure ?", "Delete selection", 0)) == 0) {
            ((GraphNode)this.selection).destroy();
            this.selection = null;
            this.btnDelete.setVisible(false);
            this.currentTool.abortTool();
        }
    }

    private void updateDisplayedRelations() {
        this.displayedRelationsModel.showAdjacent = this.chkAdjacent.isSelected();
        this.displayedRelationsModel.showImageNextTo = this.chkImageNextTo.isSelected();
        this.displayedRelationsModel.showInSegment = this.chkInSegment.isSelected();
        this.displayedRelationsModel.showSceneNextTo = this.chkSceneNextTo.isSelected();
        this.viewPort.repaint();
    }

    private void translateMouseEvent(MouseEvent evt) {
        if (this.image != null && this.viewPort.getZoom() * this.image.getWidth(null) < this.scrollPane.getViewport().getWidth() && this.viewPort.getZoom() * this.image.getHeight(null) < this.scrollPane.getViewport().getHeight()) {
            evt.translatePoint(-(this.scrollPane.getViewport().getWidth() / 2 - this.viewPort.getZoom() * this.image.getWidth(null) / 2), -(this.scrollPane.getViewport().getHeight() / 2 - this.viewPort.getZoom() * this.image.getHeight(null) / 2));
        }
    }

    private void adaptScrollbars(final int xpos, final int ypos) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int zoom = AnnotatorView.this.viewPort.getZoom();
                int semisubx = ((AnnotatorView)AnnotatorView.this).scrollPane.getViewport().getSize().width / 2;
                int semisuby = ((AnnotatorView)AnnotatorView.this).scrollPane.getViewport().getSize().height / 2;
                int mx = xpos - semisubx;
                int my = ypos - semisuby;
                if (mx < 0) {
                    mx = 0;
                }
                if (my < 0) {
                    my = 0;
                }
                if (mx > zoom * AnnotatorView.this.image.getWidth() - semisubx) {
                    mx = zoom * AnnotatorView.this.image.getWidth() - semisubx;
                }
                if (my > zoom * AnnotatorView.this.image.getHeight() - semisuby) {
                    my = zoom * AnnotatorView.this.image.getHeight() - semisuby;
                }
                AnnotatorView.this.scrollPane.getHorizontalScrollBar().setValue(mx);
                AnnotatorView.this.scrollPane.getVerticalScrollBar().setValue(my);
            }
        });
    }

    public void onToolQuit(Tool tool) {
        Annotable suggestedSelection = tool.getSuggestedSelection();
        this.clearToolButtons();
        this.tblProperties.setModel(new EmptyTableModel());
        this.lblSelection.setText("(no selection)");
        this.btnDelete.setVisible(false);
        if (tool.suggestsRelationSelect()) {
            this.btnSelectRelation.setSelected(true);
            this.currentTool = new SelectRelationTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture, this.displayedRelationsModel);
        } else {
            this.btnSelect.setSelected(true);
            this.currentTool = new SelectTool(this, this.getRootPane().getActionMap(), this.getRootPane().getInputMap(2), this.currentPicture);
        }
        if (suggestedSelection != null) {
            this.currentTool.suggestSelection(suggestedSelection);
        }
        this.viewPort.repaint();
    }

    public void onToolCursorToggle(boolean showCursor) {
        if (showCursor) {
            this.viewPort.hideMousePointer();
            this.viewPort.showCursor();
        } else {
            this.viewPort.showMousePointer();
            this.viewPort.hideCursor();
        }
    }

    public void onToolQueryRepaint() {
        this.viewPort.repaint();
    }

    public void onToolSelectionChanged(Object selection) {
        this.selection = null;
        if (selection instanceof Annotable) {
            this.tblProperties.setModel(new AnnotationsTableModel((Annotable)selection));
            this.lblSelection.setText(selection.toString());
            this.selection = selection;
            this.btnDelete.setVisible(true);
        } else {
            if (selection == null) {
                this.lblSelection.setText("(no selection)");
            } else {
                this.lblSelection.setText("(unknown)");
            }
            this.btnDelete.setVisible(false);
        }
    }

    private void updateRecentProjectsMenu() {
        boolean showRecentProjects = false;
        int currentProjectNum = 0;
        for (JMenuItem mnuRecent : this.recentProjectsMenus) {
            this.fileMenu.remove(mnuRecent);
        }
        this.recentProjectsMenus.clear();
        int menuPosition = this.fileMenu.getPopupMenu().getComponentZOrder(this.mnuFileSeparator2);
        for (Map.Entry<String, String> entry : this.recentProjects.entrySet()) {
            String projectName = entry.getValue();
            String projectFileName = entry.getKey();
            if (projectName == null) continue;
            JRecentProjectMenuItem mnuRecent = new JRecentProjectMenuItem();
            mnuRecent.setText(projectName);
            mnuRecent.setName("mnuRecent" + ++currentProjectNum);
            mnuRecent.setProjectFileName(projectFileName);
            mnuRecent.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnnotatorView.this.mnuOpenRecentProjectActionPerformed(e);
                }
            });
            this.fileMenu.insert(mnuRecent, menuPosition);
            this.recentProjectsMenus.add(mnuRecent);
            showRecentProjects = true;
        }
        this.mnuFileSeparator2.setVisible(showRecentProjects);
    }

    protected void loadRecentProjects() {
        this.recentProjects.clear();
        for (int i = 0; i < 4; ++i) {
            String projectName = this.prefs.get("recent_project_name_" + i, null);
            String projectPath = this.prefs.get("recent_project_path_" + i, null);
            if (projectName == null || projectPath == null) continue;
            AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(projectName, projectPath);
            this.recentProjects.put(projectPath, projectName);
        }
    }

    private void updateRecentProjects() {
        int i = 0;
        for (Map.Entry<String, String> entry : this.recentProjects.entrySet()) {
            this.prefs.put("recent_project_path_" + i, entry.getKey());
            this.prefs.put("recent_project_name_" + i, entry.getValue());
            ++i;
        }
        while (i < 4) {
            this.prefs.remove("recent_project_name_" + i);
            this.prefs.remove("recent_project_path_" + i);
            ++i;
        }
        this.updateRecentProjectsMenu();
    }

    private void addRecentProject(String projectPath, String projectFileName) {
        if (this.recentProjects.containsKey(projectPath)) {
            this.recentProjects.remove(projectPath);
        }
        this.recentProjects.put(projectPath, projectFileName);
        this.updateRecentProjects();
    }

    private void setCurrentProject(Project project) {
        ObjectCache.clear();
        this.project = project;
        if (project.getFilename() != null) {
            File projectFile = new File(project.getFilename());
            this.addRecentProject(projectFile.getAbsolutePath(), projectFile.getName());
        }
        this.currentPictureIterator = project.Pictures().listIterator();
        this.currentPicture = this.currentPictureIterator.hasNext() ? this.currentPictureIterator.next() : null;
        this.displayPicture();
    }

    private void clearToolButtons() {
        this.btnAddSegment.setSelected(false);
        this.btnSelect.setSelected(false);
        this.btnAddObject.setSelected(false);
        this.btnSplitEdge.setSelected(false);
        this.btnAddEdge.setSelected(false);
        this.btnSelectRelation.setSelected(false);
        this.btnAddRelation.setSelected(false);
        this.setComboBoxesEnabled(true);
    }

    private void setComboBoxesEnabled(boolean enabled) {
        this.cbRelationDestination.setEnabled(enabled);
        this.cbRelationSource.setEnabled(enabled);
        this.cbRelationType.setEnabled(enabled);
    }

    public void objectNameChanged() {
        if (this.selection != null) {
            this.lblSelection.setText(this.selection.toString());
        }
    }

    private RelationTool.GraphNodeType getNodeType(JComboBox cbNodeType) {
        switch (cbNodeType.getSelectedIndex()) {
            case 0: {
                return RelationTool.GraphNodeType.EDGE;
            }
            case 1: {
                return RelationTool.GraphNodeType.SEGMENT;
            }
            case 2: {
                return RelationTool.GraphNodeType.OBJECT;
            }
        }
        return null;
    }

    private RelationTool.RelationType getRelationType(JComboBox cbRelationType) {
        switch (cbRelationType.getSelectedIndex()) {
            case 0: {
                return RelationTool.RelationType.INSEGMENT;
            }
            case 1: {
                return RelationTool.RelationType.IMAGENEXTTO;
            }
            case 2: {
                return RelationTool.RelationType.SCENENEXTTO;
            }
            case 3: {
                return RelationTool.RelationType.ADJACENT;
            }
        }
        return null;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public Picture getCurrentPicture() {
        return this.currentPicture;
    }

    private void initTasks() {
        Task.init();
        for (Map.Entry<String, List<Task>> category : Task.getTasksByCategory().entrySet()) {
            JMenu mnuCategory = new JMenu();
            mnuCategory.setText(category.getKey());
            this.menuBar.add((Component)mnuCategory, 1);
            for (Task task : category.getValue()) {
                JMenuItem mnuTask = new JMenuItem();
                mnuTask.setText(task.getName());
                this.initTaskMenuItem(mnuTask, task);
                mnuCategory.add(mnuTask);
            }
        }
    }

    protected void initTaskMenuItem(JMenuItem mnuTask, final Task task) {
        mnuTask.setIcon(task.getIcon());
        mnuTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                task.launch(AnnotatorView.this.project, AnnotatorView.this.currentPicture);
            }
        });
    }

    private void registerKeystrokes() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("nextimage", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AnnotatorView.this.btnNextActionPerformed(e);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control PAGE_DOWN"), "nextimage");
        inputMap.put(KeyStroke.getKeyStroke("control RIGHT"), "nextimage");
        actionMap.put("previousimage", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AnnotatorView.this.btnPreviousActionPerformed(e);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control PAGE_UP"), "previousimage");
        inputMap.put(KeyStroke.getKeyStroke("control LEFT"), "previousimage");
        this.btnNext.setToolTipText("control RIGHT/control PAGE DOWN");
        this.btnPrevious.setToolTipText("control LEFT/control PAGE UP");
        actionMap.put("deleteselection", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AnnotatorView.this.btnDeleteActionPerformed(e);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), "deleteselection");
        this.toolClassesActions.put(SelectTool.class, this.btnSelect);
        this.toolClassesActions.put(SegmentTool.class, this.btnAddSegment);
        this.toolClassesActions.put(EdgeTool.class, this.btnAddEdge);
        this.toolClassesActions.put(ObjectTool.class, this.btnAddObject);
        this.toolClassesActions.put(SplitEdgeTool.class, this.btnSplitEdge);
        this.toolClassesActions.put(SelectRelationTool.class, this.btnSelectRelation);
        this.toolClassesActions.put(RelationTool.class, this.btnAddRelation);
        for (final Map.Entry<Class, AbstractButton> entry : this.toolClassesActions.entrySet()) {
            KeyStrokeCommand annotation = entry.getKey().getAnnotation(KeyStrokeCommand.class);
            if (annotation == null) continue;
            String value = annotation.value();
            KeyStroke stroke = KeyStroke.getKeyStroke(value);
            this.getRootPane().getActionMap().put("toolclass_" + entry.getKey().getName(), new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    ((AbstractButton)entry.getValue()).getActionListeners()[0].actionPerformed(e);
                }
            });
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(annotation.value()), "toolclass_" + entry.getKey().getName());
            entry.getValue().setToolTipText(annotation.value());
        }
    }
}

