#ifndef ACCEL_H
#define ACCEL_H

/**
 * @brief Non-accelerated PicoBlaze operation. Fixed for 126 steps.
 *
 * Two pairs (predict and update) of lifting steps and coefficients scaling
 * merged together.
 *
 * @param[in] scaling Perform scaling of coefficients. Possible values are:
 *   @li s = 0 : without scaling,
 *   @li s > 0 : scaling after lifting,
 *   @li s < 0 : scaling before lifting.
 */
void accel_lift_op4s_main126_s(
        float *arr,
        int steps,
        float alpha,
        float beta,
        float gamma,
        float delta,
        float zeta,
        int scaling);

#endif
