#include "accel.h"
#include <assert.h>

void accel_lift_op4s_main126_s(
        float *arr,
        int steps,
        float alpha,
        float beta,
        float gamma,
        float delta,
        float zeta,
        int scaling)
{
        assert( steps == 126 );

        if( scaling < 0 )
        {
                for(int s = 0; s < 126; s++)
                {
                        arr[4+s*2] *= 1/zeta;
                }

                for(int s = 0; s < 126; s++)
                {
                        arr[5+s*2] *= zeta;
                }
        }

        const float coeffs[4] = {delta, gamma, beta, alpha};

        for(int off = 4; off >= 1; off--)
        {
                float *out = arr+off;

                const float c = coeffs[off-1];

                for(int s = 0; s < 126; s++)
                {
                        out[0] += c * (out[-1] + out[+1]);

                        out += 2;
                }
        }

        if( scaling > 0 )
        {
                for(int s = 0; s < 126; s++)
                {
                        arr[0+s*2] *= 1/zeta;
                }

                for(int s = 0; s < 126; s++)
                {
                        arr[1+s*2] *= zeta;
                }
        }
}
