/*
 * main.cpp
 *
 *  Created on: 22.12.2011
 *      Author: isvoboda
 */

#include "ppd.hpp"
#include "opencv2/opencv.hpp"

int main(int argc, char* argv[])
{
	//Missing settings file*
	if(argc < 2)
			return -1;

	ppd::SettingsReader options = ppd::SettingsReader(argv[1]);
	ppd::DataSetReader reader;
	ppd::VOC voc;
	ppd::Extractor extractor;
	ppd::ExtractorManager extractorManager;
	extractorManager.set_resolution(640, 480);

	options.Read();

	switch (options.get_descriptor_type())
	{
	case ppd::SettingsReader::SIFT:
		extractor = ppd::Extractor(cv::FeatureDetector::create("SIFT"), cv::DescriptorExtractor::create("SIFT"));
		break;
	case ppd::SettingsReader::SURF:
		extractor =  ppd::Extractor(cv::FeatureDetector::create("SURF"), cv::DescriptorExtractor::create("SURF"));
		break;
	case ppd::SettingsReader::SIFT_COLOR:
		extractor = ppd::Extractor(cv::FeatureDetector::create("SIFT"), cv::DescriptorExtractor::create("OpponentSIFT"));
		break;
	case ppd::SettingsReader::SURF_COLOR:
		extractor =  ppd::Extractor(cv::FeatureDetector::create("SURF"), cv::DescriptorExtractor::create("OpponentSURF"));
		break;
	default:
		extractor =  ppd::Extractor(cv::FeatureDetector::create("SURF"), cv::DescriptorExtractor::create("SURF"));
		break;
	}

	reader.work_all();
	reader.set_properties(options);
	try{reader.initialize();}
	catch(ppd::Exception *e){std::cerr << e->get() << std::endl; delete e; return -1;}

	voc.set_voc_size(options.get_voc_size());

	voc.createVOC(reader, extractor, extractorManager);
	std::cout << "Descriptor extracting DONE." << std::endl;

	voc.saveVOC(options.get_voc_file_name());
	std::cout << "VOC creating DONE." << std::endl;

	return 0;
}
