/*
 * settings_reader.hpp
 *
 *  Created on: 19.11.2011
 *      Author: isvoboda
 */

#ifndef SETTINGS_READER_HPP_
#define SETTINGS_READER_HPP_

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include "opencv2/opencv.hpp"

#define TIXML_USE_TICPP
#include "XmlParser/ticpp.h"

namespace ppd
{

/**
 * Reads the settings file.
 */
class SettingsReader
{
public:
	/**
	 * NonParametric constructor.
	 */
	SettingsReader();

	/**
	 * Parametric constructor.
	 * @param file_name - name of the settings file
	 */
	SettingsReader(const std::string file_name);

	/**
	 * Reads and parse the settings file.
	 */
	void Read(void);

	/**
	 * Reads and parse the settings file.
	 * @param file_name - settings file
	 */
	void Read(const std::string file_name);

	/**
	 * Setter of the settings file.
	 * @param file_name
	 */
	void SetSettingsFile(const std::string file_name);

	/**
	 * Prints the read and parsed settings file to the standard output.
	 */
	void PrintSettings();

	enum Descriptor{SURF = 1, SIFT = 2, SURF_COLOR = 3, SIFT_COLOR = 4};

private:

	void initialize();

	std::string file_name;

	int type;					//-1 - negative; 0 - occlusion; 1 - positive
	std::string classType;		//Class type
	std::string path_img_sets;	//path to file defining the images names and the flag of occurrence of specific class
	std::string data_list;		//File defining names of files - images
	std::string path_ann;		//Path to folder with annotations
	std::string path_img;		//Path to folder with images

	std::string descriptor_file;
	std::string voc_file;
	std::string bow_features_file;
	unsigned int voc_size;

	std::string svm_type;
	std::string svm_kernel_type;
	double svm_kernel_rbf_param_gamma;
	double svm_nu;
	double svm_c;

	CvParamGrid gamma_grid;
	CvParamGrid c_grid;

	std::string bow_fg_file;
	std::string bow_fg;
	std::string bow_bg_file;
	std::string bow_bg;

	std::string svm_name;
	std::string svm_file;

	std::string svm_scaling_parameters;

	Descriptor descriptor;

	unsigned int scan_row_step;
	unsigned int scan_col_step;

	unsigned int detector_window_x;
	unsigned int detector_window_y;
	float detector_window_scale_factor;
	unsigned int detector_min_neigbours;

public:
	std::string get_class() const;
	std::string get_path_img_sets() const;
	std::string get_data_list_file() const;
	std::string get_path_ann() const;
	std::string get_path_img() const;

	Descriptor get_descriptor_type() const;

	std::string get_descriptor_file_name() const;
	std::string get_voc_file_name() const;
	std::string get_bow_features_file_name() const;
	unsigned int get_voc_size() const;

	std::string get_svm_type() const;
	std::string get_svm_kernel_type() const;
	double get_svm_kernel_rbf_param_gamma() const;
	double get_svm_nu() const;
	CvParamGrid get_svm_gamma_grid() const;
	CvParamGrid get_svm_c_grid() const;

	std::string get_bow_fg() const;
	std::string get_bow_bg() const;
	std::string get_bow_fg_name() const;
	std::string get_bow_bg_name() const;

	std::string get_svm_file_name() const;
	std::string get_svm_name() const;
	std::string get_svm_sacle_parameters() const;

	unsigned int get_scan_row_step();
	unsigned int get_scan_col_step();

	unsigned int get_detector_window_x();
	unsigned int get_detector_window_y();
	float get_detector_scan_factor();
	unsigned int get_detector_min_neigbours();

};

}

#endif /* SETTINGS_READER_HPP_ */
